/*!\file Result.cpp
 * \brief: implementation of the Result object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./Result.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./ParameterInputs.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"

Result::Result(){
	return;
}

Result::Result(const Result& result){

	id=result.id;
	time=result.time;
	step=result.step;
	size=result.size;
	
	/*copy constructor: copy dynamically allocated fields: */
	if(result.fieldname){
		fieldname=(char*)xmalloc((strlen(result.fieldname)+1)*sizeof(char));
		strcpy(fieldname,result.fieldname);
	}
	if(result.field){
		VecDuplicatePatch(&field,result.field);
		dfield=NULL;
		cfield=NULL;
	}
	if(result.dfield){
		dfield=(double*)xmalloc(result.size*sizeof(double));
		memcpy(dfield,result.dfield,result.size*sizeof(double));
		field=NULL;
		cfield=NULL;
	}
	if(result.cfield){
		cfield=(char*)xmalloc((strlen(result.cfield)+1)*sizeof(char));
		strcpy(cfield,result.cfield);
		field=NULL;
		dfield=NULL;
	}
}

#undef __FUNCT__ 
#define __FUNCT__ "Result::Result"
Result::Result(int result_id,double result_time,int result_step,char* result_fieldname,Vec result_field){

	id=result_id;
	time=result_time;
	step=result_step;
	
	if(!result_fieldname){
		throw  ErrorException(__FUNCT__," NULL fieldname in constructor argument");
	}
	else{
		fieldname=(char*)xmalloc((strlen(result_fieldname)+1)*sizeof(char));
		strcpy(fieldname,result_fieldname);
	}

	VecDuplicatePatch(&field,result_field);
	dfield=NULL;
	cfield=NULL;
}

#undef __FUNCT__ 
#define __FUNCT__ "Result::Result"
Result::Result(int result_id,double result_time,int result_step,char* result_fieldname,double* result_field,int result_size){

	id=result_id;
	time=result_time;
	step=result_step;
	
	if(!result_fieldname){
		throw  ErrorException(__FUNCT__," NULL fieldname in constructor argument");
	}
	else{
		fieldname=(char*)xmalloc((strlen(result_fieldname)+1)*sizeof(char));
		strcpy(fieldname,result_fieldname);
	}

	dfield=(double*)xmalloc(result_size*sizeof(double));
	memcpy(dfield,result_field,result_size*sizeof(double));
	size=result_size;
	field=NULL;
	cfield=NULL;
}

#undef __FUNCT__ 
#define __FUNCT__ "Result::Result"
Result::Result(int result_id,double result_time,int result_step,char* result_fieldname,char* result_field){

	id=result_id;
	time=result_time;
	step=result_step;
	
	if(!result_fieldname){
		throw  ErrorException(__FUNCT__," NULL fieldname in constructor argument");
	}
	else{
		fieldname=(char*)xmalloc((strlen(result_fieldname)+1)*sizeof(char));
		strcpy(fieldname,result_fieldname);
	}
	cfield=(char*)xmalloc((strlen(result_field)+1)*sizeof(char));
	strcpy(cfield,result_field);

	field=NULL;
	dfield=NULL;
}

Result::~Result(){
	xfree((void**)&fieldname);
	VecFree(&field);
	xfree((void**)&dfield);
	xfree((void**)&cfield);
}
		
void Result::Echo(void){

	printf("Result:\n");
	printf("   id: %i\n",id);
	printf("   time: %g\n",time);
	printf("   step: %i\n",step);
	printf("   field name: %s\n",fieldname);
	if(field){
		printf("   field pointer %p\n",field);
	}
	if(dfield){
		printf("   field pointer %p\n",dfield);
		printf("   field size %i\n",size);
	}
	if(cfield){
		printf("   field pointer %p\n",cfield);
		printf("   field string %s\n",cfield);
	}
}

void Result::DeepEcho(void){

	printf("Result:\n");
	printf("   id: %i\n",id);
	printf("   time: %g\n",time);
	printf("   step: %i\n",step);
	printf("   field name: %s\n",fieldname);
	if(field){
		printf("   field pointer %p\n",field);
	}
	if(dfield){
		printf("   field pointer %p\n",dfield);
		printf("   field size %i\n",size);
	}
	if(cfield){
		printf("   field pointer %p\n",cfield);
		printf("   field string %s\n",cfield);
	}
}	

#undef __FUNCT__ 
#define __FUNCT__ "Result::Marshall"
void  Result::Marshall(char** pmarshalled_dataset){

	throw  ErrorException(__FUNCT__," not supported yet!");

}
	
#undef __FUNCT__ 
#define __FUNCT__ "Result::MarshallSize"
int   Result::MarshallSize(){

	throw  ErrorException(__FUNCT__," not supported yet!");
}

char* Result::GetName(void){
	return "result";
}
		

#undef __FUNCT__ 
#define __FUNCT__ "Result::Demarshall"
void  Result::Demarshall(char** pmarshalled_dataset){

	throw  ErrorException(__FUNCT__," not supported yet!");
}

int Result::Enum(void){

	return ResultEnum();

}
int    Result::GetId(void){ return id; }

int    Result::MyRank(void){ 
	extern int my_rank;

	return my_rank; 
}

double Result::GetTime(){
	return time;
}

int    Result::GetStep(){
	return step;
}

char*    Result::GetFieldName(){
	return fieldname;
}
		
void   Result::WriteData(FILE* fid){

	int length;
	int type;

	/*First write field name :*/
	length=(strlen(fieldname)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(fieldname,length,1,fid);

	/*Now write time and step: */
	fwrite(&time,sizeof(double),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*Now write field: */
	if(dfield){
		type=1;
		fwrite(&type,sizeof(int),1,fid);
		fwrite(&size,sizeof(int),1,fid);
		fwrite(dfield,size*sizeof(double),1,fid);
	}
	if(cfield){
		type=2;
		fwrite(&type,sizeof(int),1,fid);
		length=(strlen(cfield)+1)*sizeof(char);
		fwrite(&length,sizeof(int),1,fid);
		fwrite(cfield,length,1,fid);
	}
}


void  Result::GetField(Vec* pfield){

	VecDuplicatePatch(pfield,field);

}

void  Result::GetField(char** pcfield){

	char* string=NULL;

	string=(char*)xmalloc((strlen(cfield)+1)*sizeof(char));
	strcpy(string,cfield);

	*pcfield=string;
}

void  Result::GetField(double** pfield){
	*pfield=(double*)xmalloc(size*sizeof(double));
	memcpy(*pfield,dfield,size*sizeof(double));
}

Object* Result::copy() {
	return new Result(*this); 
}
		

