%Test Name: SquareShelfSMBGemb
md=triangle(model(),'../Exp/Square.exp',500000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',4); % 3 for the cluster

%md.verbose=verbose('all');

% Use of Gemb method for SMB computation
md.smb = SMBgemb(md.mesh,md.geometry);

%load hourly surface forcing date from 1979 to 2009:
inputs=load('../Data/gemb_input.mat');

%setup the time line: 
deltatindays=(inputs.dateN(2) - inputs.dateN(1));
dateN=(1979:deltatindays/365.25:2011)';
dateN(length(inputs.dateN)+1:end)=[];

%setup the inputs: 
md.smb.Ta=[repmat(inputs.Ta0',md.mesh.numberofelements,1);dateN'];
md.smb.V=[repmat(inputs.V0',md.mesh.numberofelements,1);dateN'];
md.smb.dswrf=[repmat(inputs.dsw0',md.mesh.numberofelements,1);dateN'];
md.smb.dlwrf=[repmat(inputs.dlw0',md.mesh.numberofelements,1);dateN'];
md.smb.P=[repmat(inputs.P0',md.mesh.numberofelements,1);dateN'];
md.smb.eAir=[repmat(inputs.eAir0',md.mesh.numberofelements,1);dateN'];
md.smb.pAir=[repmat(inputs.pAir0',md.mesh.numberofelements,1);dateN'];
md.smb.Vz=repmat(inputs.LP.Vz,md.mesh.numberofelements,1);
md.smb.Tz=repmat(inputs.LP.Tz,md.mesh.numberofelements,1);
md.smb.Tmean=repmat(inputs.LP.Tmean,md.mesh.numberofelements,1);
md.smb.C=repmat(inputs.LP.C,md.mesh.numberofelements,1);

%smb settings
md.smb.requested_outputs={'SmbDz','SmbT','SmbD','SmbRe','SmbGdn','SmbGsp','SmbEC','SmbA','SmbMassBalance','SmbSwf'};

md.materials.rho_ice=910;
md.timestepping.interp_forcings=0;

%only run smb core: 
md.transient.isstressbalance=0;
md.transient.ismasstransport=0;
md.transient.isthermal=0;

%time stepping: 
md.timestepping.start_time=1979;
md.timestepping.final_time=1980;
md.timestepping.time_step=.1;

%Run transient
md=solve(md,TransientSolutionEnum());

%Fields and tolerances to track changes
field_names          ={'SmbDz','SmbT' ,'SmbD' ,'SmbRe','SmbGdn','SmbGsp','SmbA' ,'SmbEC','SmbMassBalance'};
field_tolerances     ={'1e-13','1e-13','1e-13','1e-13','1e-13' ,'1e-13' ,'1e-13','1e-13','1e-13'};

field_values={...
	(md.results.TransientSolution(end).SmbDz(1,:)),...
	(md.results.TransientSolution(end).SmbT(1,:)),...
	(md.results.TransientSolution(end).SmbD(1,:)),...
	(md.results.TransientSolution(end).SmbRe(1,:)),...
	(md.results.TransientSolution(end).SmbGdn(1,:)),...
	(md.results.TransientSolution(end).SmbGsp(1,:)),...
	(md.results.TransientSolution(end).SmbA(1,:)),...
	(md.results.TransientSolution(end).SmbEC(1)),...
	(md.results.TransientSolution(end).SmbMassBalance(1)),...
	};
