%MASK class definition
%
%   Usage:
%      mask=mask();

classdef mask
	properties (SetAccess=public) 
		groundedice_levelset = NaN;
		ice_levelset         = NaN;
	end
	methods (Static)
		function self = loadobj(self) % {{{
			% This function is directly called by matlab when a model object is
			% loaded. Update old properties here

			%2014 February 5th
			if numel(self.ice_levelset)>1 & all(self.ice_levelset>=0),
				disp('WARNING: md.mask.ice_levelset>=0, you probably need to change the sign of this levelset');
			end

		end% }}}
	end
	methods
		function createxml(self,fid) % {{{
			fprintf(fid, '\n\n');
			fprintf(fid, '%s\n', '<!-- mask -->');
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','<parameter key ="groundedice_levelset" type="',class(self.groundedice_levelset),'" default="',self.groundedice_levelset,'">','     <section name="mask" />','     <help> is ice grounded ? grounded ice if > 0, grounding line position if = 0, floating ice if &amp;lt; 0 </help>','</parameter>');
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n','<parameter key ="ice_levelset" type="',class(self.ice_levelset),'" default="',self.ice_levelset,'">','     <section name="mask" />','     <help> presence of ice if > 0, icefront position if = 0, no ice if &amp;lt; 0 </help>','</parameter>');
		end % }}}
		function self = extrude(self,md) % {{{
			self.groundedice_levelset=project3d(md,'vector',self.groundedice_levelset,'type','node');
			self.ice_levelset=project3d(md,'vector',self.ice_levelset,'type','node');
		end % }}}
		function self = mask(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','mask.groundedice_levelset','size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','mask.ice_levelset'        ,'size',[md.mesh.numberofvertices 1]);
			isice=(md.mask.ice_levelset<=0);
			if sum(isice)==0,
				warning('no ice present in the domain');
			end
			if max(md.mask.ice_levelset)<0,
				warning('no ice front provided');
			end
			icefront=sum(md.mask.ice_levelset(md.mesh.elements)==0,2);
			if (max(icefront)==3 & strcmp(elementtype(md.mesh),'Tria')) | (max(icefront==6) & strcmp(elementtype(md.mesh),'Penta')),
				error('At least one element has all nodes on ice front, change md.mask.ice_levelset to fix it')
			end
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   masks:'));

			fielddisplay(self,'groundedice_levelset','is ice grounded ? grounded ice if > 0, grounding line position if = 0, floating ice if < 0');
			fielddisplay(self,'ice_levelset','presence of ice if < 0, icefront position if = 0, no ice if > 0');
		end % }}}
		function marshall(self,md,fid) % {{{
			WriteData(fid,'object',self,'fieldname','groundedice_levelset','format','DoubleMat','mattype',1);
			WriteData(fid,'object',self,'fieldname','ice_levelset','format','DoubleMat','mattype',1);

			% get mask of vertices of elements with ice
			isice=md.mask.ice_levelset<=0.;
			vlist = zeros(md.mesh.numberofvertices,1);
			if md.mesh.numberofelements==1,
				pos=find(sum(isice(md.mesh.elements),1)>0);
			else
				pos=find(sum(isice(md.mesh.elements),2)>0);
			end
			vlist(md.mesh.elements(pos,:))=1;
			WriteData(fid,'data',vlist,'enum',IceMaskNodeActivationEnum(),'format','DoubleMat','mattype',1);

		end % }}}
	end
end
