#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.6.0 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-lite-3.6.0.tar.gz' 'petsc-3.6.0.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.6.0.tar.gz
mv petsc-3.6.0/* src/
rm -rf petsc-3.6.0

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-blas-lapack-dir="$TACC_MKL_LIB" \
	--with-mpi-lib="/opt/apps/intel11_1/mvapich2/1.6/lib/libmpich.so" \
	--with-mpi-include="/opt/apps/intel11_1/mvapich2/1.6/include/" \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=1 

#prepare script to reconfigure petsc
cat > script.queue << EOF
#!/bin/bash		 
#$ -V		#Inherit the submission environment
#$ -cwd	# Start job in submission directory
#$ -N petscinstall # Job Name
#$ -j y	# Combine stderr and stdout
#$ -o $JOB_NAME.o$JOB_ID	# Name of the output file (eg. myMPI.oJobID)
#$ -pe 12way 12	# Requests 12 tasks/node, 12 cores total
#$ -q normal	# Queue name normal
#$ -l h_rt=00:01:00	# Run time (hh:mm:ss) - 1.5 hours
set -x	# Echo commands, use set echo with csh

module load cmake/2.8.7
module load mkl/10.3

mpiexec -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
