%Test Name: SquareShelfSMBGemb
md=triangle(model(),'../Exp/Square.exp',500000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',1); % 3 for the cluster

%md.verbose=verbose('all');

% Use of Gemb method for SMB computation
md.smb = SMBgemb(md.mesh,md.geometry);

%load hourly surface forcing date from 1979 to 2009:
inputs=load('~/gemb/TEST/TEST_INPUT_1.mat');

dateN=inputs.dateN/365.25; %convert in years
md.smb.Ta=[repmat(inputs.Ta0',md.mesh.numberofelements,1);dateN'];
md.smb.V=[repmat(inputs.V0',md.mesh.numberofelements,1);dateN'];
md.smb.dswrf=[repmat(inputs.dsw0',md.mesh.numberofelements,1);dateN'];
md.smb.dlwrf=[repmat(inputs.dlw0',md.mesh.numberofelements,1);dateN'];
md.smb.P=[repmat(inputs.P0',md.mesh.numberofelements,1);dateN'];
md.smb.eAir=[repmat(inputs.eAir0',md.mesh.numberofelements,1);dateN'];
md.smb.pAir=[repmat(inputs.pAir0',md.mesh.numberofelements,1);dateN'];

md.smb.Vz=repmat(inputs.LP.Vz,md.mesh.numberofelements,1);
md.smb.Tz=repmat(inputs.LP.Tz,md.mesh.numberofelements,1);
md.smb.Tmean=repmat(inputs.LP.Tmean,md.mesh.numberofelements,1);
md.smb.C=repmat(inputs.LP.C,md.mesh.numberofelements,1);

%settings
md.smb.ismelt=0;
md.smb.isthermal=0;
md.smb.isalbedo=0;
md.transient.isstressbalance=0;
md.transient.ismasstransport=0;
md.transient.isthermal=0;
md.timestepping.start_time=2000;
md.timestepping.final_time=2001;
md.timestepping.time_step=1/12; %monthly

md.verbose=verbose('11111111');

%Run transient
md=solve(md,TransientSolutionEnum());
