%Test Name: SquareShelfSMBGemb
md=triangle(model(),'../Exp/Square.exp',500000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',1); % 3 for the cluster

%md.verbose=verbose('all');

% Use of Gemb method for SMB computation
md.smb = SMBgemb(md.mesh,md.geometry);

%load hourly surface forcing date from 1979 to 2009:
inputs=load('~/gemb/TEST/TEST_INPUT_1.mat');

dateN=inputs.dateN/365.25; %convert in years
md.smb.Ta=[repmat(inputs.Ta0',md.mesh.numberofelements,1);dateN'];
md.smb.V=[repmat(inputs.V0',md.mesh.numberofelements,1);dateN'];
md.smb.dswrf=[repmat(inputs.dsw0',md.mesh.numberofelements,1);dateN'];
md.smb.dlwrf=[repmat(inputs.dlw0',md.mesh.numberofelements,1);dateN'];
md.smb.P=[repmat(inputs.P0',md.mesh.numberofelements,1);dateN'];
md.smb.eAir=[repmat(inputs.eAir0',md.mesh.numberofelements,1);dateN'];
md.smb.pAir=[repmat(inputs.pAir0',md.mesh.numberofelements,1);dateN'];

md.smb.Vz=inputs.LP.Vz;
md.smb.Tz=inputs.LP.Tz;
md.smb.Tmean=inputs.LP.Tmean;
md.smb.C=inputs.LP.C;

%settings
md.smb.spinUp=2;

%Run transient
md=solve(md,TransientSolutionEnum());
