%Test Name: SquareShelfSMBGemb
md=triangle(model(),'../Exp/Square.exp',500000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',1); % 3 for the cluster

%md.verbose=verbose('all');

% Use of Gemb method for SMB computation
md.surfaceforcings = SMBgemb(md.mesh,md.geometry);

%load hourly surface forcing date from 1979 to 2009:
inputs=load('~/gemb/TEST/TEST_INPUT_1.mat');

dateN=inputs.dateN/365.25; %convert in years
md.surfaceforcings.Ta=[repmat(inputs.Ta0',md.mesh.numberofelements,1);dateN'];
md.surfaceforcings.V=[repmat(inputs.V0',md.mesh.numberofelements,1);dateN'];
md.surfaceforcings.dswrf=[repmat(inputs.dsw0',md.mesh.numberofelements,1);dateN'];
md.surfaceforcings.dlwrf=[repmat(inputs.dlw0',md.mesh.numberofelements,1);dateN'];
md.surfaceforcings.P=[repmat(inputs.P0',md.mesh.numberofelements,1);dateN'];
md.surfaceforcings.eAir=[repmat(inputs.eAir0',md.mesh.numberofelements,1);dateN'];
md.surfaceforcings.pAir=[repmat(inputs.pAir0',md.mesh.numberofelements,1);dateN'];

md.surfaceforcings.Vz=inputs.LP.Vz;
md.surfaceforcings.Tz=inputs.LP.Tz;
md.surfaceforcings.Tmean=inputs.LP.Tmean;
md.surfaceforcings.C=inputs.LP.C;

%settings
md.surfaceforcings.spinUp=2

%Run transient
md=solve(md,TransientSolutionEnum());
