#!/bin/bash
set -eu 
VER="3.3.1"

#Some cleanup
rm -rf install cmake-3.3.1
mkdir install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/cmake-3.3.1.tar.gz' 'cmake-3.3.1.tar.gz'

#Untar 
tar -zxvf  cmake-3.3.1.tar.gz

#Move cmake into install directory
mv cmake-3.3.1/* install
rm -rf cmake-3.3.1

#Compile cmake
cd install 
./bootstrap --prefix=$ISSM_DIR/externalpackages/cmake/install
if [ $# -eq 0 ]; then
	make
else 
	make -j $1; 
fi
make install
