function Ke=PentaCollapseIntoTriaMatrix(pentaelem,grids,materials,inputs,analysis_type);
%PENTACOLLAPSEINTOTRIAMATRIX - collapse a pentaelem into a tria and create a stiffness matrix for ths element
%
%   This routine creates a fake triaelem from the pentaelem and then call the routine
%   to create a stiffness matrix fot this triaelem.
%   It is usefull when running MacAyeal's model on a 3d mesh.
%
%   Usage:
%      Ke=PentaCollapseIntoTriaMatrix(pentaelem,grids,materials,inputs,analysis_type)
%
%   See also PENTACOLLAPSEINTOTRIAVECTOR, CREATEKMATRIX

	%we collapse the penta into its base tria, and use the tria to build the stiffness matrix.
	element=triaelem;
	element.type='triaelem';
	element.id=NaN; %not needed here, we are going to destroy this triaelem very soon.
	element.matid=pentaelem.matid; %same materials, not dependent on element.
	element.g=pentaelem.g(1:3); %first three grids correspond to the base of the penta element.
	element.h=pentaelem.h(1:3);
	element.s=pentaelem.s(1:3);
	element.b=pentaelem.b(1:3);
	element.friction_type=pentaelem.friction_type;
	element.k=pentaelem.k(1:3);
	element.p=pentaelem.p;
	element.q=pentaelem.q;
	element.shelf=pentaelem.shelf;
	element.meanvel=pentaelem.meanvel;
	element.epsvel=pentaelem.epsvel;
	element.viscosity_overshoot=pentaelem.viscosity_oveshoot;

	%Call CreateKMatrix for this new element.
	Ke=CreateKMatrix(element,grids,materials,inputs,analysis_type);
