/*!\file FemModel.c
 * \brief: implementation of the FemModel object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./FemModel.h"
#include "stdio.h"
#include "../shared/shared.h"

FemModel::FemModel(){

	elements=NULL;
	nodes=NULL;
	constraints=NULL;
	loads=NULL;
	materials=NULL;
	parameters=NULL;

	partition=NULL;
	tpartition=NULL;
	yg=NULL;
	Rmg=NULL;
	nodesets=NULL;
	ys=NULL;
	ys0=NULL;
	Gmn=NULL;

}

FemModel::FemModel(DataSet* femmodel_elements,DataSet* femmodel_nodes,DataSet* femmodel_constraints,DataSet* femmodel_loads,
		DataSet* femmodel_materials,DataSet* femmodel_parameters, Vec femmodel_partition,Vec femmodel_tpartition,Vec femmodel_yg,
		Mat femmodel_Rmg,Mat femmodel_Gmn,NodeSets* femmodel_nodesets,Vec femmodel_ys,Vec femmodel_ys0){


	elements=femmodel_elements;
	nodes=femmodel_nodes;
	constraints=femmodel_constraints;
	loads=femmodel_loads;
	materials=femmodel_materials;
	parameters=femmodel_parameters;

	partition=femmodel_partition;
	tpartition=femmodel_tpartition;
	yg=femmodel_yg;
	Rmg=femmodel_Rmg;
	nodesets=femmodel_nodesets;
	ys=femmodel_ys;
	ys0=femmodel_ys0;
	Gmn=femmodel_Gmn;

}

FemModel::~FemModel(){

	delete elements;
	delete nodes;
	delete loads;
	delete constraints;
	delete materials;
	delete parameters;

	VecFree(&partition);
	VecFree(&tpartition);
	VecFree(&yg);
	MatFree(&Rmg);
	delete nodesets;
	VecFree(&ys);
	VecFree(&ys0);
	MatFree(&Gmn);

}

#undef __FUNCT__
#define __FUNCT__ "FemModel::Echo"

void FemModel::Echo(void){

	printf("FemModels echo: \n");
	printf("   elements: %p\n",elements);
	printf("   nodes: %p\n",nodes);
	printf("   loads: %p\n",loads);
	printf("   materials: %p\n",materials);
	printf("   parameters: %p\n",parameters);
	
	printf("   partition: %p\n",partition);
	printf("   tpartition: %p\n",tpartition);
	printf("   yg: %p\n",yg);
	printf("   Rmg: %p\n",Rmg);
	printf("   nodesets: %p\n",nodesets);
	printf("   ys: %p\n",ys);
	printf("   ys0: %p\n",ys0);
	printf("   Gmn: %p\n",Gmn);

}
#undef __FUNCT__
#define __FUNCT__ "FemModel::DeepEcho"

void FemModel::DeepEcho(void){
	
	printf("FemModels echo: \n");
	printf("   elements: \n");
	elements->Echo();
	printf("   nodes: \n");
	nodes->Echo();
	printf("   loads: \n");
	nodes->Echo();
	printf("   materials: \n");
	nodes->Echo();
	printf("   parameters: \n");
	nodes->Echo();
	
	printf("   partition: \n");
	VecView(partition,PETSC_VIEWER_STDOUT_WORLD);
	printf("   tpartition: \n");
	VecView(tpartition,PETSC_VIEWER_STDOUT_WORLD);
	printf("   yg: \n");
	VecView(yg,PETSC_VIEWER_STDOUT_WORLD);
	printf("   Rmg: \n");
	MatView(Rmg,PETSC_VIEWER_STDOUT_WORLD);
	printf("   nodesets: \n");
	nodesets->Echo();
	printf("   ys: \n");
	VecView(ys,PETSC_VIEWER_STDOUT_WORLD);
	printf("   ys0: \n");
	VecView(ys0,PETSC_VIEWER_STDOUT_WORLD);
	printf("   Gmn: \n");
	MatView(Gmn,PETSC_VIEWER_STDOUT_WORLD);

}
#undef __FUNCT__
#define __FUNCT__ "FemModel::GetId"
int   FemModel::GetId(void){
	throw ErrorException(__FUNCT__,exprintf("%s%s",__FUNCT__," error message: not implemented yet!"));
}

#undef __FUNCT__
#define __FUNCT__ "FemModel::MyRank"
int   FemModel::MyRank(void){
	throw ErrorException(__FUNCT__,exprintf("%s%s",__FUNCT__," error message: not implemented yet!"));
}

#undef __FUNCT__
#define __FUNCT__ "FemModel::Marshall"
void  FemModel::Marshall(char** pmarshalled_dataset){
	throw ErrorException(__FUNCT__,exprintf("%s%s",__FUNCT__," error message: not implemented yet!"));
}

#undef __FUNCT__
#define __FUNCT__ "FemModel::MarshallSize"
int   FemModel::MarshallSize(void){
	throw ErrorException(__FUNCT__,exprintf("%s%s",__FUNCT__," error message: not implemented yet!"));
}
#undef __FUNCT__
#define __FUNCT__ "FemModel::GetName"
char*   FemModel::GetName(void){
	throw ErrorException(__FUNCT__,exprintf("%s%s",__FUNCT__," error message: not implemented yet!"));
}
#undef __FUNCT__
#define __FUNCT__ "FemModel::Demarshall"
void  FemModel::Demarshall(char** pmarshalled_dataset){
	throw ErrorException(__FUNCT__,exprintf("%s%s",__FUNCT__," error message: not implemented yet!"));
}
#undef __FUNCT__
#define __FUNCT__ "FemModel::Enum"
int   FemModel::Enum(void){
	throw ErrorException(__FUNCT__,exprintf("%s%s",__FUNCT__," error message: not implemented yet!"));
}
#undef __FUNCT__
#define __FUNCT__ "FemModel::copy"
Object* FemModel::copy(void){
	throw ErrorException(__FUNCT__,exprintf("%s%s",__FUNCT__," error message: not implemented yet!"));
}

#undef __FUNCT__
#define __FUNCT__ "FemModel::FindParam"
int FemModel::FindParam(void* pparameter,char* parametername){
	
	return parameters->FindParam(pparameter,parametername);

}

/*access to internal data: */
DataSet*            FemModel::get_elements(void){return elements;}
DataSet*            FemModel::get_nodes(void){return nodes ;}
DataSet*            FemModel::get_constraints(void){return constraints ;}
DataSet*            FemModel::get_loads(void){return loads;}
DataSet*            FemModel::get_materials(void){return materials;}
DataSet*            FemModel::get_parameters(void){return parameters;}
Vec                 FemModel::get_partition(void){return partition;}
Vec                 FemModel::get_tpartition(void){return tpartition;}
Vec                 FemModel::get_yg(void){return yg;}
Mat                 FemModel::get_Rmg(void){return Rmg;}
NodeSets*           FemModel::get_nodesets(void){return nodesets;}
Vec                 FemModel::get_ys(void){return ys;}
Vec                 FemModel::get_ys0(void){return ys0;}
Mat                 FemModel::get_Gmn(void){return Gmn;}
