#!/bin/bash

numprocs=8;

#figure out if startup.m is here, otherwise, symlink it.
if [ -e startup.m ]
then
	echo ""
	#startup.m exists, do nothing
else
	echo "creating startup.m symlink file"
	ln -s $ISSM_DIR/startup.m 
fi


for (( i=1;i<=$numprocs;i++ ))
do

	#Launch matlab and the nightly run script
	cat > matlab_run$i.m << EOF
	startup
	warning off %necessary to avoid a nightly.log of several Go for cielo_parallel
	try,
		nightlyrun({'cielo_serial'},$i,$numprocs);
	catch me,
		%An error occured, get report and exit
		message=getReport(me)
		fid=fopen('matlaberror$i.log', 'wt');
		fprintf(fid,'Matlab error occured in: %s\n',pwd);                                                                                                       
		fprintf(fid,'%s',message);                                                                                                                              
		fclose(fid);
	end
	exit
EOF

	matlab -nojvm -nosplash  -r matlab_run$i -logfile nightlylong$i.log &
done

wait

#concatenate all reports
mv nightlylong1.log  nightlylong.log
for (( i=2;i<=$numprocs;i++ ))
do
	cat nightlylong.log nightlylong$i.log > nightlylong.log.bak
	mv nightlylong.log.bak nightlylong.log
	rm nightlylong$i.log

done

#remove unused lines to deal with a smaller file
cat nightlylong.log | egrep 'difference: |NIGHTLYRUNTERMINATEDCORRECTLY' > nightly.log
rm nightlylong.log

#remove matlab_run scripts.
rm -rf matlab_run*.m
