%GENERIC cluster class definition
%
%   Usage:
%      cluster=generic_static('name','astrid','np',3);

classdef generic_static
	properties (SetAccess=public) 
		% {{{
		name='';
		np=1;
		codepath=fileparts(which('issm.exe'));
		executionpath = '.';
		interactive = 1;
		shell='/bin/sh';
		%}}}
	end
	methods
		function cluster=generic_static(varargin) % {{{

			%use provided options to change fields
			options=pairoptions(varargin{:});

			%get name
			cluster.name=getfieldvalue(options,'name',oshostname());

			%initialize cluster using user settings if provided
			if (exist([cluster.name '_settings'])==2), eval([cluster.name '_settings']); end

			%OK get other fields
			cluster=AssignObjectFields(pairoptions(varargin{:}),cluster);
		end
		%}}}
		function disp(cluster) % {{{
			%  display the object
			disp(sprintf('class ''%s'' object ''%s'' = ',class(cluster),inputname(1)));
			disp(sprintf('    name: %s',cluster.name));
			disp(sprintf('    np: %i',cluster.np));
			disp(sprintf('    codepath: %s',cluster.codepath));
			disp(sprintf('    shell: %s',cluster.shell));
		end
		%}}}
		function md = checkconsistency(cluster,md,solution,analyses) % {{{
			if cluster.np<1
				md = checkmessage(md,['number of processors should be at least 1']);
			end
			if isnan(cluster.np),
				md = checkmessage(md,'number of processors should not be NaN!');
			end
		end
		%}}}
		function BuildQueueScript(cluster,dirname,modelname,solution,io_gather,isvalgrind,isgprof) % {{{

			%write queuing script 
			fid=fopen([modelname '.queue'],'w');
			fprintf(fid,'#!%s\n',cluster.shell);
			fprintf(fid,[cluster.codepath '/mpiexec -np %i %s/issm.exe %s %s %s \n'],cluster.np,cluster.codepath,EnumToString(solution),'./',modelname);
			fclose(fid);

			%in interactive mode, create a run file, and errlog and outlog file
			fid=fopen([modelname '.errlog'],'w'); fclose(fid);
			fid=fopen([modelname '.outlog'],'w'); fclose(fid);
		end
		%}}}
		function UploadQueueJob(cluster,modelname,dirname,filelist)% {{{

			%do nothing
		end %}}}
		function LaunchQueueJob(cluster,modelname,dirname,filelist,restart)% {{{

			if ~ispc,

				%figure out what shell extension we will use:
				if isempty(strfind(cluster.shell,'csh')),
					shellext='sh';
				else
					shellext='csh';
				end

				disp('launching solution sequence');
				launchcommand=['source  ' modelname '.queue '];
				issmssh(cluster.name,'',0,launchcommand);
			else
				system([modelname '.bat']);
			end
		end %}}}
		function Download(cluster,dirname,filelist)% {{{
				%do nothing
				return;
		end %}}}
	end
end
