function oce_lm = ocelm(sh,lMax,ocean,areaEle) 

%OCElm :: a function to compute SH coefficients of ocean function 
% 
%USAGE: oce_lm = ocelm(sh,lMax,ocean,areaEle); 
%
%sh (spherical harmonics) 
%lMax (maximum SH degree to be considered) 
%ocean (ocean function) 
%areaEle (area of elements) 
%

p1 = 0; 

oce_lm = zeros(1,(lMax+1)^2); 

% weighted area integration 
for l=0:lMax
   for m=-l:l
      oce_lm(1+p1) = sum((sh(:,1+p1).*ocean').*areaEle');
      p1 = p1+1;
   end
end
oce_lm = oce_lm/sum(areaEle);

