function prepare_gl(md,options)

scaling_factor=getfieldvalue(options,'scaling_factor',50);

%scripts to be picked up from directory:
scriptsdir=['~/issm-projects/visl/externalicelab/fem'];

%some checks: 
if isempty(md.mesh.lat) | isnan(md.mesh.lat) | isempty(md.mesh.long) | isnan(md.mesh.long),
	error('prepare_gl error message: need lat and long in md.mesh to be filled up!');
end

%database: {{{
if strcmpi(md.mesh.hemisphere','s'),
	radar_image_earth='/Users/larour/ModelData/TrueMarble_GeoTIFF/radar_no_antarctica.png';
	triangulation_earth='/Users/larour/ModelData/DEM_geotiff/processed/triangulation_antarctica.mat';
	triangulation='/Users/larour/ModelData/BamberDEMAntarctica1km/triangulated/triangulation_15.mat';
	radar_image='/Users/larour/ModelData/BamberDEMAntarctica1km/triangulated/radar.latlong.png';

elseif strcmpi(md.mesh.hemisphere','n'),
	radar_image_earth='/Users/larour/ModelData/TrueMarble_GeoTIFF/radar_no_greenland.png';
	triangulation_earth='/Users/larour/ModelData/DEM_geotiff/processed/triangulation_greenland.mat';
	triangulation='/u/astrid-r1b/ModelData/HowatDEMGreenland2012/triangulated/triangulation_2.mat';
	radar_image='/u/astrid-r1b/ModelData/HowatDEMGreenland2012/triangulated/radar.latlong.png';
else
	error('prepare_gl error usage: ''hemisphere'' should be set to ''s'' or ''n''');
end
%}}}

%keep present directory: 
presentdir=pwd;

%Setup unique directory in present dir: 
directory=getfieldvalue(options,'webpagename','.webgl');
mkdir(directory);
cd(directory);

%Copy scripts needed:
copyfile([scriptsdir '/css'],'./css');
copyfile([scriptsdir '/../css/main.css'],'./css');
copyfile([scriptsdir '/images'],'./images');
copyfile([scriptsdir '/obj'],'./obj');
copyfile([scriptsdir '/src'],'./src');
copyfile([scriptsdir '/js'],'./js');
copyfile([scriptsdir '/generic'],'./generic');
copyfile([scriptsdir '/generic.html'],'.');

database=['./generic/'];

%handle rendering of the whole planet: {{{
tr=load(triangulation_earth);
index=tr.index; lat=tr.lat; long=tr.long; surface=tr.surface;

%we get index, lat long and surface, make this into a planet sphere: 

R=6371000*ones(length(surface),1)+scaling_factor*surface;

x = R .* cosd(lat) .* cosd(long);
y = R .* cosd(lat) .* sind(long);
z = R .* sind(lat);


%write x0, x1, y0 and y1
fid=fopen([database '/image_coords.js'],'w');
fprintf(fid,'var x0=%g;\n',min(x));
fprintf(fid,'var x1=%g;\n',max(x));
fprintf(fid,'var y0=%g;\n',min(y));
fprintf(fid,'var y1=%g;\n',max(y));
fprintf(fid,'var z0=%g;\n',min(z));
fprintf(fid,'var z1=%g;\n',max(z));
fprintf(fid,'var lat0=%g;\n',min(lat));
fprintf(fid,'var lat1=%g;\n',max(lat));
fprintf(fid,'var long0=%g;\n',min(long));
fprintf(fid,'var long1=%g;\n',max(long));
fclose(fid);

system(['cp ' radar_image_earth ' ' database '/radar.png']);

numberofvertices=length(x);
numberofelements=length(index);

%write triangulation and surface to disk: 
fid=fopen([database '/surface_triangulation.js'],'w');

%write index:
fprintf(fid,'<!-- index_surface{{{-->\n');
fprintf(fid,'var index_surface=[');
for i=1:numberofelements-1,
	fprintf(fid,'[%i, %i, %i],',index(i,1),index(i,2),index(i,3));
end
fprintf(fid,'[%i, %i, %i]];\n',index(end,1),index(end,2),index(end,3));
fprintf(fid,'<!--}}}-->\n');

%write x:
fprintf(fid,'<!-- x_surface{{{-->\n');
fprintf(fid,'var x_surface=[');
for i=1:numberofvertices-1,
	fprintf(fid,'%g,',x(i,1));
end
fprintf(fid,'%g];\n',x(end,1));
fprintf(fid,'<!--}}}-->\n');

%write y:
fprintf(fid,'<!-- y_surface{{{-->\n');
fprintf(fid,'var y_surface=[');
for i=1:numberofvertices-1,
	fprintf(fid,'%g,',y(i,1));
end
fprintf(fid,'%g];\n',y(end,1));
fprintf(fid,'<!--}}}-->\n');

%write z:
fprintf(fid,'<!-- z_surface{{{-->\n');
fprintf(fid,'var z_surface=[');
for i=1:numberofvertices-1,
	fprintf(fid,'%g,',z(i,1));
end
fprintf(fid,'%g];\n',z(end,1));
fprintf(fid,'<!--}}}-->\n');

%write lat:
fprintf(fid,'<!-- lat_surface{{{-->\n');
fprintf(fid,'var lat_surface=[');
for i=1:numberofvertices-1,
	fprintf(fid,'%g,',lat(i,1));
end
fprintf(fid,'%g];\n',lat(end,1));
fprintf(fid,'<!--}}}-->\n');

%write long:
fprintf(fid,'<!-- long_surface{{{-->\n');
fprintf(fid,'var long_surface=[');
for i=1:numberofvertices-1,
	fprintf(fid,'%g,',long(i,1));
end
fprintf(fid,'%g];\n',long(end,1));
fprintf(fid,'<!--}}}-->\n');

fclose(fid);
%}}}
%handle rendering of Antarctica and Greenland wholy{{{

load(triangulation);

R=6371000*ones(length(x),1)+scaling_factor*surface;

if strcmpi(md.mesh.hemisphere','s'),
	[lat,long]=xy2ll(x,y,-1);
elseif strcmpi(md.mesh.hemisphere','n'),
	[lat,long]=xy2ll(x,y,1);
end

x = R .* cosd(lat) .* cosd(long);
y = R .* cosd(lat) .* sind(long);
z = R .* sind(lat);

x0=min(x); x1=max(x);
y0=min(y); y1=max(y);
z0=min(z); z1=max(z);
lat0=min(lat); lat1=max(lat);long0=min(long);long1=max(long);


%write x0, x1, y0 and y1
fid=fopen([database '/image_coords_highdef.js'],'w');

fprintf(fid,'var x0_hd=%g;\n',x0);
fprintf(fid,'var x1_hd=%g;\n',x1);
fprintf(fid,'var y0_hd=%g;\n',y0);
fprintf(fid,'var y1_hd=%g;\n',y1);
fprintf(fid,'var z0_hd=%g;\n',z0);
fprintf(fid,'var z1_hd=%g;\n',z1);
fprintf(fid,'var lat0_hd=%g;\n',lat0);
fprintf(fid,'var lat1_hd=%g;\n',lat1);
fprintf(fid,'var long0_hd=%g;\n',long0);
fprintf(fid,'var long1_hd=%g;\n',long1);
fclose(fid);


%copy corresponding image: 
system(['cp ' radar_image ' ' database '/radar_hd.png']);

numberofvertices=length(x);
numberofelements=length(index);

%write triangulation and surface to disk: 
fid=fopen([database '/surface_triangulation_hd.js'],'w');

%write index:
fprintf(fid,'<!-- index_surface_hd{{{-->\n');
fprintf(fid,'var index_surface_hd=[');
for i=1:numberofelements-1,
	fprintf(fid,'[%i, %i, %i],',index(i,1),index(i,2),index(i,3));
end
fprintf(fid,'[%i, %i, %i]];\n',index(end,1),index(end,2),index(end,3));
fprintf(fid,'<!--}}}-->\n');

%write x:
fprintf(fid,'<!-- x_surface_hd{{{-->\n');
fprintf(fid,'var x_surface_hd=[');
for i=1:numberofvertices-1,
	fprintf(fid,'%g,',x(i,1));
end
fprintf(fid,'%g];\n',x(end,1));
fprintf(fid,'<!--}}}-->\n');

%write y:
fprintf(fid,'<!-- y_surface_hd{{{-->\n');
fprintf(fid,'var y_surface_hd=[');
for i=1:numberofvertices-1,
	fprintf(fid,'%g,',y(i,1));
end
fprintf(fid,'%g];\n',y(end,1));
fprintf(fid,'<!--}}}-->\n');

%write z:
fprintf(fid,'<!-- z_surface_hd{{{-->\n');
fprintf(fid,'var z_surface_hd=[');
for i=1:numberofvertices-1,
	fprintf(fid,'%g,',z(i,1));
end
fprintf(fid,'%g];\n',z(end,1));
fprintf(fid,'<!--}}}-->\n');

%write lat:
fprintf(fid,'<!-- lat_surface_hd{{{-->\n');
fprintf(fid,'var lat_surface_hd=[');
for i=1:numberofvertices-1,
	fprintf(fid,'%g,',lat(i,1));
end
fprintf(fid,'%g];\n',lat(end,1));
fprintf(fid,'<!--}}}-->\n');

%write long:
fprintf(fid,'<!-- long_surface_hd{{{-->\n');
fprintf(fid,'var long_surface_hd=[');
for i=1:numberofvertices-1,
	fprintf(fid,'%g,',long(i,1));
end
fprintf(fid,'%g];\n',long(end,1));
fprintf(fid,'<!--}}}-->\n');

fclose(fid);


%}}}

%Come back to present directory: 
cd(presentdir);
