function export_gl(md,varargin)

	templist=plotoptions(varargin{:}); 
	optionslist=templist.list;
	options=optionslist{1};
	options=checkplotoptions(md,options);

	%Setup unique directory in present dir: 
	directory=getfieldvalue(options,'directory','./');
	databasename=getfieldvalue(options,'database','webgl');

	%scaling factor: 
	scaling_factor=getfieldvalue(options,'scaling_factor',50);

	%Deal with title: 
	if exist(options,'title')
		title=getfieldvalue(options,'title');
	else
		title='';
	end

	%initialize model: 
	model.title=title;
	model.initialZoomFactor=getfieldvalue(options,'zoom',-.25);

	%Deal with contour {{{

	contour_lat=md.mesh.lat(md.mesh.segments(:,1));
	contour_long=md.mesh.long(md.mesh.segments(:,1));
	contour_surface=md.geometry.surface(md.mesh.segments(:,1));

	R=6371000*ones(length(contour_surface),1)+scaling_factor*contour_surface;

	contourx = R .* cosd(contour_lat) .* cosd(contour_long);
	contoury = R .* cosd(contour_lat) .* sind(contour_long);
	contourz = R .* sind(contour_lat);

	model.contourx=contourx;
	model.contoury=contoury;
	model.contourz=contourz;

	%}}}
%Deal with mesh and results {{{
	
	
	lat=md.mesh.lat;
	long=md.mesh.long;
	surface=md.geometry.surface;
	numberofelements=md.mesh.numberofelements;
	numberofvertices=md.mesh.numberofvertices;

	R=6371000*ones(numberofvertices,1)+scaling_factor*surface;

	x = R .* cosd(lat) .* cosd(long);
	y = R .* cosd(lat) .* sind(long);
	z = R .* sind(lat);


	%Deal with triangulation: 
	model.index=md.mesh.elements;
	model.x=x;
	model.y=y;
	model.z=z;
	model.surface=surface;
	
	%Deal with data: 
	results=struct([]);
	for i=1:length(optionslist),
		options=optionslist{i}; options=checkplotoptions(md,options);
		data=getfieldvalue(options,'data');
		results(i).data=data;
		results(i).caxis=getfieldvalue(options,'caxis',[min(data(:)) max(data(:))]);

		label=getfieldvalue(options,'label','');
		if strcmpi(label,''),
			%create generic label: 
			label=['data' num2str(i)];
		end
		results(i).label=label;

		shortlabel=getfieldvalue(options,'shortlabel','');
		if strcmpi(shortlabel,''),
			%create generic short label: 
			shortlabel=['data' num2str(i)];
		end
		results(i).shortlabel=shortlabel;
		
		if size(data,2)>1,
			time_range=getfieldvalue(options,'time_range',[0 100]);
			results(i).time_range=time_range;
		end

		unit=getfieldvalue(options,'unit','');
		if strcmpi(unit,''),
			%create generic unit: 
			unit='SI';
		end
		results(i).unit=unit;
	end
	model.results=results;
	
	%Write model to javascript database file: 
	writejsfile([directory databasename '.js'],model,databasename);
%}}}
