function plotgl(md,optionslist)
scriptsdir=['~/issm-projects/visl/externalicelab/fem'];

%check on existing of webgl directory: 
if ~exist('.webgl','dir'),
	prepare_gl(md,checkplotoptions(md,optionslist{1}));
end
	
options=optionslist{1};
options=checkplotoptions(md,options);

%keep present directory: 
presentdir=pwd;

%Setup unique directory in present dir: 
directory=getfieldvalue(options,'webpagename','.webgl');
database=['./generic/'];
cd(directory);

%copy editables.js file
copyfile([scriptsdir '/generic/editables.js'],'./generic/editables.js');

%scaling factor: 
scaling_factor=getfieldvalue(options,'scaling_factor',50);

%Deal with title: 
if exist(options,'title')
	title=getfieldvalue(options,'title');
else
	title='';
end
replacestringinfile('./generic/editables.js','Generic Plot',title);

%height scaling:
replacestringinfile('./generic/editables.js','var height_scaling = 60.0;',['var height_scaling = ' num2str(getfieldvalue(options,'height_scaling',60)) ';']);

%size of frame: 
replacestringinfile('./css/mystyle.css','height: 55%; /*editable*/',['height: ' num2str(getfieldvalue(options,'frame_height',55)) '%; /*editable*/']);


%high resolution: 
if ~getfieldvalue(options,'highres',0);
	replacestringinfile('./generic/editables.js','var hdBackgroundImageFileName = experiment_name + "/radar_hd.png";','var hdBackgroundImageFileName = "";');
end

%ocean zero threshold: 
replacestringinfile('./generic/editables.js','var ocean_threshold = 637.0;',['var ocean_threshold = ' num2str(getfieldvalue(options,'ocean_threshold',.001)) ';']);

%intial view angle: 
replacestringinfile('./generic/editables.js','var view_number_default = 3;',['var view_number_default = ' num2str(getfieldvalue(options,'view_number_default',3)) ';']);
	
%zoom
replacestringinfile('./generic/editables.js','initialZoomFactor = -.20;',['initialZoomFactor = ' num2str(getfieldvalue(options,'zoom',-.25)) ';']);
	

%initialize model: 
model.title=title;
model.initialZoomFactor=getfieldvalue(options,'zoom',-.25);

%Deal with contour {{{

contour_lat=md.mesh.lat(md.mesh.segments(:,1));
contour_long=md.mesh.long(md.mesh.segments(:,1));
contour_surface=md.geometry.surface(md.mesh.segments(:,1));

R=6371000*ones(length(contour_surface),1)+scaling_factor*contour_surface;

contourx = R .* cosd(contour_lat) .* cosd(contour_long);
contoury = R .* cosd(contour_lat) .* sind(contour_long);
contourz = R .* sind(contour_lat);

model.contourx=contourx;
model.contoury=contoury;
model.contourz=contourz;

%}}}
%Deal with mesh and results {{{
	
	
	lat=md.mesh.lat;
	long=md.mesh.long;
	surface=md.geometry.surface;
	numberofelements=md.mesh.numberofelements;
	numberofvertices=md.mesh.numberofvertices;

	R=6371000*ones(numberofvertices,1)+scaling_factor*surface;

	x = R .* cosd(lat) .* cosd(long);
	y = R .* cosd(lat) .* sind(long);
	z = R .* sind(lat);


	%Deal with triangulation: 
	model.index=md.mesh.elements;
	model.x=x;
	model.y=y;
	model.z=z;
	model.surface=surface;
	
	%Deal with data: 
	results=struct([]);
	for i=1:length(optionslist),
		options=optionslist{i}; options=checkplotoptions(md,options);
		data=getfieldvalue(options,'data');
		results(i).data=data;
		results(i).caxis=getfieldvalue(options,'caxis',[min(data(:)) max(data(:))]);

		label=getfieldvalue(options,'label','');
		if strcmpi(label,''),
			%create generic label: 
			label=['data' num2str(i)];
		end
		results(i).label=label;

		shortlabel=getfieldvalue(options,'shortlabel','');
		if strcmpi(shortlabel,''),
			%create generic short label: 
			shortlabel=['data' num2str(i)];
		end
		results(i).shortlabel=shortlabel;

		unit=getfieldvalue(options,'unit','');
		if strcmpi(unit,''),
			%create generic unit: 
			unit='SI';
		end
		results(i).unit=unit;
	end
	model.results=results;
	
	%Write model to javascript database file: 
	writejsfile([database directory '.js'],model,directory);
%}}}

%Open browser with results: 
web('./generic.html','-browser');

%Come back to present directory: 
cd(presentdir);


