function mask = gmtmask(lat,long)
%GMTMASK - figure out which lat,long points are on the ocean
%
%   Usage:
%      mask.ocean = gmtmask(md.mesh.lat,md.mesh.long);
%


	%First, write our lat,long file for gmt:
	nv=length(lat);
	dlmwrite('./all_vertices.txt',[long lat (1:nv)'],'delimiter','\t');

	%Avoid bypassing of the ld library path by Matlab (:()
	if ismac,
		dyld_library_path_old=getenv('DYLD_LIBRARY_PATH');
		setenv('DYLD_LIBRARY_PATH',[ issmdir '/externalpackages/curl/install/lib:' issmdir '/externalpackages/hdf5/install/lib:' issmdir '/externalpackages/netcdf/install/lib' ]);
	end

	%figure out which vertices are on the ocean, which one on the continent:
	system('gmt gmtselect ./all_vertices.txt -h0 -Df -R0/360/-90/90  -A0 -JQ180/200 -Nk/s/k/s/k > ./oce_vertices.txt');

	%reset DYLD_LIBRARY_PATH to what it was: 
	if ismac,
		setenv('DYLD_LIBRARY_PATH',dyld_library_path_old);
	end
	%read the con_vertices.txt file and flag our mesh vertices on the continent
	fid=fopen('./oce_vertices.txt','r');
	line=fgets(fid); 
	line=fgets(fid);
	oce_vertices=[];
	while line~=-1,
		ind=str2num(line); ind=ind(3);
		oce_vertices=[oce_vertices;ind];
		line=fgets(fid);
	end


	mask=zeros(nv,1);
	mask(oce_vertices)=1;
	
	system('rm -rf ./all_vertices.txt ./oce_vertices.txt ./gmt.history');
