function yp_pq = yplm(lMax,nPix,rho_o,rho_e,zlr_pq,oce_pq,loveH,loveK) 

%---------------------------------------------------------------------
% yplm :: a function to compute SH coefficients for Y' 
%---------------------------------------------------------------------
% This code is written as a part of the ISSM-PSL project
% (c) S. Adhikari 
%     Jet Propulsion Laboratory, Caltech 
%     November 3, 2014
%---------------------------------------------------------------------

q1 = 0; 

for p=0:lMax
   for q=-p:p 
      if (p<1) 
         yp_pq(1+q1) = 3*(rho_o/rho_e)*zlr_pq(1+q1)/(2*p+1);
      else 
         yp_pq(1+q1) = 3*(rho_o/rho_e)*zlr_pq(1+q1)*(1+loveK(p)-loveH(p))/(2*p+1);
      end
      q1 = q1+1; 
   end 
end 

yp_pq(1) = yp_pq(1) - sum(yp_pq.*oce_pq)/oce_pq(1);

