function x_lm = xxlm(lMax,nPix,rho_i,rho_e,ice_pq,oce_pq,ocean,sh,loveH,loveK) 

%---------------------------------------------------------------------
% xxlm :: a function to compute SH coefficient for X 
%---------------------------------------------------------------------
% This code is written as a part of the ISSM-PSL project
% (c) S. Adhikari 
%     Jet Propulsion Laboratory, Caltech 
%     November 3, 2014
%---------------------------------------------------------------------

q1 = 0; 
q2 = 0; 

% obtain xp_pq 
xp_pq = xplm(lMax,nPix,rho_i,rho_e,ice_pq,oce_pq,loveH,loveK); 

% compute xp, i.e. x' 
xp = zeros(1,nPix);
for p=0:lMax
   for q = -p:p
      xp = xp + xp_pq(1+q1).*sh(:,1+q1)';
      q1 = q1 + 1;
   end
end

x_lm = zeros(1,(lMax+1)^2);
for l=0:lMax
   for m=-l:l
      x_lm(1+q2) = sum((xp'.*sh(:,1+q2)).*ocean');
      q2 = q2+1;
   end
end
% 
x_lm = x_lm*4*pi/nPix;

