function y_lm = yylm(lMax,nPix,rho_o,rho_e,zlr_pq,oce_pq,ocean,sh,loveH,loveK) 

%---------------------------------------------------------------------
% yylm :: a function to compute SH coefficient for Y  
%---------------------------------------------------------------------
% This code is written as a part of the ISSM-PSL project
% (c) S. Adhikari 
%     Jet Propulsion Laboratory, Caltech 
%     November 3, 2014
%---------------------------------------------------------------------

q1 = 0; 
q2 = 0; 

% obtain yp_pq
yp_pq = yplm(lMax,nPix,rho_o,rho_e,zlr_pq,oce_pq,loveH,loveK); 

% compute yp, i.e. y'
yp = zeros(1,nPix);
for p=0:lMax
   for q = -p:p
      yp = yp + yp_pq(1+q1).*sh(:,1+q1)';
      q1 = q1 + 1;
   end
end

y_lm = zeros(1,(lMax+1)^2);
% 
for l=0:lMax
   for m=-l:l
      y_lm(1+q2) = sum((yp'.*sh(:,1+q2)).*ocean');
      q2 = q2+1;
   end
end
% 
y_lm = y_lm*4*pi/nPix;

