function xp_pq = xplm(lMax,nPix,rho_i,rho_e,ice_pq,oce_pq,loveH,loveK) 

%---------------------------------------------------------------------
% xplm :: a function to compute SH coefficient for X'  
%---------------------------------------------------------------------
% This code is written as a part of the ISSM-PSL project
% (c) S. Adhikari 
%     Jet Propulsion Laboratory, Caltech 
%     November 3, 2014
%---------------------------------------------------------------------

q1 = 0; 

for p=0:lMax
   for q=-p:p 
      if (p<1) 
         xp_pq(1+q1) = 3*(rho_i/rho_e)*ice_pq(1+q1)/(2*p+1);
      else 
         xp_pq(1+q1) = 3*(rho_i/rho_e)*ice_pq(1+q1)*(1+loveK(p)-loveH(p))/(2*p+1);
      end
      q1 = q1+1; 
   end 
end 

xp_pq(1) = xp_pq(1) - sum(xp_pq.*oce_pq)/oce_pq(1);

