function ice_lm = icelm(lMax,nPix,ice,sh) 

%---------------------------------------------------------------------
% icelm :: a function to compute SH coefficients of "ice load function" 
%---------------------------------------------------------------------
% This code is written as a part of the ISSM-PSL project
% (c) S. Adhikari 
%     Jet Propulsion Laboratory, Caltech 
%     November 3, 2014
%---------------------------------------------------------------------

p1 = 0; 

ice_lm = zeros(1,(lMax+1)^2); 

for l=0:lMax
   for m=-l:l
      ice_lm(1+p1) = sum(sh(:,1+p1).*ice');
      p1 = p1+1;
   end
end

ice_lm = ice_lm*4*pi/nPix; 

