function results(nSide,nPix,data_dir,ice_func,oce_func,eustatic,seaLevel,displace) 

%---------------------------------------------------------------------
% results :: save results that could be plotted using GMT code (cf. gmtResults.m) 
%---------------------------------------------------------------------
% This code is written as a part of the ISSM-PSL project
% (c) S. Adhikari 
%     Jet Propulsion Laboratory, Caltech 
%     November 3, 2014
%---------------------------------------------------------------------

lon_lat = lonLat(nSide,nPix);  % (lon, lat) 
lonLat_ice = zeros(3,nPix); 
lonLat_ice(1,:) = lon_lat(1,:); 
lonLat_ice(2,:) = lon_lat(2,:); 
lonLat_ice(3,:) = ice_func; 
dlmwrite(sprintf('./data_gmt/results_%s/iceLoad.txt',data_dir),lonLat_ice','delimiter','\t'); 
lonLat_oce   = zeros(3,nPix); 
lonLat_oce(1,:) = lon_lat(1,:); 
lonLat_oce(2,:) = lon_lat(2,:); 
lonLat_oce(3,:) = oce_func; 
dlmwrite(sprintf('./data_gmt/results_%s/ocean.txt',data_dir),lonLat_oce','delimiter','\t'); 
lonLat_eus = zeros(3,nPix); 
lonLat_eus(1,:) = lon_lat(1,:); 
lonLat_eus(2,:) = lon_lat(2,:); 
lonLat_eus(3,:) = eustatic; 
dlmwrite(sprintf('./data_gmt/results_%s/eustatic.txt',data_dir),lonLat_eus','delimiter','\t'); 
lonLat_slr = zeros(3,nPix); 
lonLat_slr(1,:) = lon_lat(1,:); 
lonLat_slr(2,:) = lon_lat(2,:);  
lonLat_slr(3,:) = seaLevel ; 
dlmwrite(sprintf('./data_gmt/results_%s/seaLevel.txt',data_dir),lonLat_slr','delimiter','\t'); 
lonLat_dis = zeros(3,nPix); 
lonLat_dis(1,:) = lon_lat(1,:); 
lonLat_dis(2,:) = lon_lat(2,:);  
lonLat_dis(3,:) = displace ; 
dlmwrite(sprintf('./data_gmt/results_%s/displace.txt',data_dir),lonLat_dis','delimiter','\t'); 

