function gmtResults(data_dir,seaLevel,ice_func,displace,farrell) 

%---------------------------------------------------------------------
% gmtResults :: a function to write a GMT code for plotting solutions 
%---------------------------------------------------------------------
% This code is written as a part of the ISSM-PSL project
% (c) S. Adhikari 
%     Jet Propulsion Laboratory, Caltech 
%     November 3, 2014
%---------------------------------------------------------------------

min_d = ceil(min(displace)); % for negative 
max_d = floor(max(displace)); 
ten_d = floor((max_d-min_d)/10);
%
min_s = ceil(min(seaLevel)); % for negative 
max_s = floor(max(seaLevel)); 
ten_s = floor((max_s-min_s)/10);
%
min_i = ceil(min(ice_func)); % for negative 
max_i = floor(max(ice_func)); 
ten_i = floor((max_i-min_i)/10);
%
ten_o = 1/10; 

text0 = ''; 
text00 = '   ;;'; 
text01 = '   #'; 
text1 = '#!/bin/sh'; 
text2 = '# GMT code for plotting results (from Selen)'; 
text3 = '# This code is written as a part of the ISSM-PSL project'; 
text4 = '# (c) Surendra Adhikari'; 
text5 = '#     Jet Propulsion Laboratory, Caltech'; 
text6 = '#     November 3, 2014'; 
text7 = sprintf('dG="./results_%s"',data_dir); 
% 
text20 = 'step=1'; 
text21 = 'case $step in'; 
text22 = '   1) # plot RSL for rigid Earth'; 
text23 = sprintf('   gmt makecpt -Cno_green -T%d/%d/%d > $dG/pale_s.cpt',min_s,max_s,ten_s); 
text24 = '   gmt psbasemap -Y19 -P -Bf180a90/f90a60WSEN -R0/360/-85/85 -JQ180/16 -K > $dG/seaLevel.ps'; 
text25 = '   gmt pscontour -I -JQ -O -K -R0/360/-85/85 $dG/seaLevel.txt -C$dG/pale_s.cpt  >> $dG/seaLevel.ps'; 
text25a = '   gmt pscontour -W0.5p -JQ -O -K -R0/360/-85/85 $dG/seaLevel.txt -C$dG/pale_s.cpt  >> $dG/seaLevel.ps'; 
text26 = '   gmt pscoast -B -R -O -K -W0.1p -JQ -Df -A1000 >> $dG/seaLevel.ps'; 
text26b = '   gmt pscoast -B -R -O -K -W0.1p -JQ -Df -Ggray -A1000 >> $dG/seaLevel.ps'; 
text27 = '   gmt psscale -U/.2/.2/"ISSM-PSL" -E -K -C$dG/pale_s.cpt -Ba:relative_sea_level:/:m: -D8/-1/10/0.75h -O >> $dG/seaLevel.ps'; 
% 
text280 = sprintf('   gmt makecpt -Cno_green -T%d/%d/%d > $dG/pale_d.cpt',min_d,max_d,ten_d); 
text281 = '   gmt psbasemap -Y-13 -P -Bf180a90/f90a60WSEN -R0/360/-85/85 -JQ180/16 -K -O >> $dG/seaLevel.ps'; 
text282 = '   gmt pscontour -I -JQ -O -K -R0/360/-85/85 $dG/displace.txt -C$dG/pale_d.cpt  >> $dG/seaLevel.ps'; 
text283 = '   gmt pscoast -B -R -O -K -W0.1p -JQ -Df -A1000 >> $dG/seaLevel.ps'; 
text284 = '   gmt psscale -U/.2/.2/"ISSM-PSL" -E -K -C$dG/pale_d.cpt -Baf:vertical_displacement:/:m: -D8/-1/10/0.75h -O >> $dG/seaLevel.ps'; 
text28 = '   open $dG/seaLevel.ps'; 
% 
text50 = '   2) # plot reconstructed ocean and ice load functions'; 
text51 = sprintf('   gmt makecpt -Cno_green -T%d/%d/%d > $dG/pale_i.cpt',min_i,max_i,ten_i); 
text52 = sprintf('   gmt makecpt -Cno_green -T0/1/%f > $dG/pale_o.cpt',ten_o); 
text53 = '   gmt psbasemap -Y19 -P -Bf180a90/f90a60WSEN -R0/360/-85/85 -JQ180/16 -K > $dG/ioFunction.ps'; 
text54 = '   gmt pscontour -I -JQ -O -K -R0/360/-85/85 $dG/ocean.txt -C$dG/pale_o.cpt  >> $dG/ioFunction.ps'; 
text55 = '   gmt pscoast -B -R -O -K -W0.1p -JQ -Df -A1000 >> $dG/ioFunction.ps'; 
text56 = '   gmt psscale -U/.2/.2/"ISSM-PSL" -E -K -C$dG/pale_o.cpt -Ba:Reconstructed_ocean_function: -D8/-1/10/0.75h -O >> $dG/ioFunction.ps'; 
% 
text57 = '   gmt psbasemap -Y-13 -P -Bf180a90/f90a60WSEN -R0/360/-85/85 -JQ180/16 -K -O >> $dG/ioFunction.ps'; 
text58 = '   gmt pscontour -I -JQ -O -K -R0/360/-85/85 $dG/iceLoad.txt -C$dG/pale_i.cpt  >> $dG/ioFunction.ps'; 
text59 = '   gmt pscoast -B -R -O -K -W0.1p -JQ -Df -A1000 >> $dG/ioFunction.ps'; 
text60 = '   gmt psscale -U/.2/.2/"ISSM-PSL" -E -K -C$dG/pale_i.cpt -Baf:Reconstructed_ice_load:/:m: -D8/-1/10/0.75h -O >> $dG/ioFunction.ps'; 
text61 = '   open $dG/ioFunction.ps'; 
text99 = 'esac'; 
% 
fid = fopen(sprintf('./data_gmt/plotResults.sh'),'w');  % "./" = ISSM_PSL directory! 
fprintf(fid,'%s\n',text1); 
fprintf(fid,'%s\n',text0); 
fprintf(fid,'%s\n',text2); 
fprintf(fid,'%s\n',text3); 
fprintf(fid,'%s\n',text4); 
fprintf(fid,'%s\n',text5); 
fprintf(fid,'%s\n',text6); 
fprintf(fid,'%s\n',text0); 
fprintf(fid,'%s\n',text7); 
% 
fprintf(fid,'%s\n',text0); 
fprintf(fid,'%s\n',text20); 
fprintf(fid,'%s\n',text0); 
fprintf(fid,'%s\n',text21); 
fprintf(fid,'%s\n',text0); 
fprintf(fid,'%s\n',text22); 
fprintf(fid,'%s\n',text23); 
fprintf(fid,'%s\n',text24); 
if (farrell==1)  % Farrell and Clark (1976) benchmark  
   fprintf(fid,'%s\n',text25a); 
   fprintf(fid,'%s\n',text26b); 
else 
   fprintf(fid,'%s\n',text25); 
   fprintf(fid,'%s\n',text26); 
   fprintf(fid,'%s\n',text27); 
end
% 
fprintf(fid,'%s\n',text01); 
fprintf(fid,'%s\n',text280); 
fprintf(fid,'%s\n',text281); 
fprintf(fid,'%s\n',text282); 
fprintf(fid,'%s\n',text283); 
fprintf(fid,'%s\n',text284); 
fprintf(fid,'%s\n',text28); 
fprintf(fid,'%s\n',text00); 
%
fprintf(fid,'%s\n',text0); 
fprintf(fid,'%s\n',text50); 
fprintf(fid,'%s\n',text51); 
fprintf(fid,'%s\n',text52); 
fprintf(fid,'%s\n',text53); 
fprintf(fid,'%s\n',text54); 
fprintf(fid,'%s\n',text55); 
fprintf(fid,'%s\n',text56); 
fprintf(fid,'%s\n',text01); 
fprintf(fid,'%s\n',text57); 
fprintf(fid,'%s\n',text58); 
fprintf(fid,'%s\n',text59); 
fprintf(fid,'%s\n',text60); 
fprintf(fid,'%s\n',text61); 
%
fprintf(fid,'%s\n',text0); 
fprintf(fid,'%s\n',text99); 
% 
fclose(fid); 

