function oce_lm = ocelm(lMax,nPix,ocean,sh) 

%---------------------------------------------------------------------
% ocelm :: a function to compute SH coefficients of "ocean function" 
%---------------------------------------------------------------------
% This code is written as a part of the ISSM-PSL project
% (c) S. Adhikari 
%     Jet Propulsion Laboratory, Caltech 
%     November 3, 2014
%---------------------------------------------------------------------
p1 = 0; 

oce_lm = zeros(1,(lMax+1)^2); 

for l=0:lMax
   for m=-l:l
      oce_lm(1+p1) = sum(sh(:,1+p1).*ocean');
      p1 = p1+1;
   end
end

oce_lm = oce_lm*4*pi/nPix;

