%SMBd18opdd Class definition
%
%   Usage:
%      SMBd18opdd=SMBd18opdd();

classdef SMBd18opdd
	properties (SetAccess=public) 
		desfac                    = 0;
		s0p                       = 0;
		s0t                       = 0;
		rlaps                     = 0;
		rlapslgm                  = 0; 
		dpermil                   = 0; 
		Tdiff                     = NaN;
		sealev                    = NaN;
		ismungsm                  = 0;
		isd18opd                  = 0;
		delta18o                  = NaN;
		delta18o_surface          = NaN;
		temperatures_presentday   = NaN;
		precipitations_presentday = NaN;
	end
	methods
		function self = SMBd18opdd(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{
			if(self.isd18opd),self.temperatures_presentday=project3d(md,'vector',self.temperatures_presentday,'type','node');end
			if(self.isd18opd),self.precipitations_presentday=project3d(md,'vector',self.precipitations_presentday,'type','node');end

		end % }}}
		function self = initialize(self,md) % {{{
                    
			% if isnan(self.precipitation),
			% 	self.precipitation=zeros(md.mesh.numberofvertices,1);
			% 	disp('      no SMBd18opdd.precipitation specified: values set as zero');
			% end

		end % }}}
		function self = setdefaultparameters(self) % {{{

		  self.ismungsm   = 0;
		  self.isd18opd   = 1;
		  self.desfac     = 0.5;
		  self.s0p        = 0;
		  self.s0t        = 0;
		  self.rlaps      = 6.5;
		  self.rlapslgm   = 6.5;
		  self.dpermil    = 2.4;
                  
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.desfac','<=',1,'numel',1);
				md = checkfield(md,'fieldname','surfaceforcings.s0p','>=',0,'numel',1);
				md = checkfield(md,'fieldname','surfaceforcings.s0t','>=',0,'numel',1);
				md = checkfield(md,'fieldname','surfaceforcings.rlaps','>=',0,'numel',1);
				md = checkfield(md,'fieldname','surfaceforcings.rlapslgm','>=',0,'numel',1);
				if(self.isd18opd==1) 
					md = checkfield(md,'fieldname','surfaceforcings.temperatures_presentday','size',[md.mesh.numberofvertices+1 12],'NaN',1);
					md = checkfield(md,'fieldname','surfaceforcings.precipitations_presentday','size',[md.mesh.numberofvertices+1 12],'NaN',1);
					md = checkfield(md,'fieldname','surfaceforcings.delta18o','NaN',1);
					md = checkfield(md,'fieldname','surfaceforcings.dpermil','>=',0,'numel',1);
				end
			end
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   surface forcings parameters:'));

			disp(sprintf('\n   PDD and deltaO18 parameters:'));
			fielddisplay(self,'isd18opd','is delta18o parametrisation from present day temperature and precipitation activated (0 or 1, default is 0)');
			fielddisplay(self,'desfac','desertification elevation factor (between 0 and 1, default is 0.5) [m]');
			fielddisplay(self,'s0p','should be set to elevation from precip source (between 0 and a few 1000s m, default is 0) [m]');
			fielddisplay(self,'s0t','should be set to elevation from temperature source (between 0 and a few 1000s m, default is 0) [m]');
			fielddisplay(self,'rlaps','present day lapse rate [degree/km]');
			if(self.isd18opd==1) 
				fielddisplay(self,'temperatures_presentday','monthly present day surface temperatures [K], required if delta18o/mungsm/d18opd is activated');
				fielddisplay(self,'precipitations_presentday','monthly surface precipitation [m/yr water eq], required if delta18o/mungsm/d18opd is activated');
				fielddisplay(self,'delta18o','delta18o [per mil], required if pdd is activated and d18opd activated');  
				fielddisplay(self,'dpermil','degree per mil, required if d18opd is activated');                            
			end
			% No need to display rlapslgm, Tdiff, ismungsm
			% as they are not used in this case but are still needed as default values in
			% PositiveDegreeDay (Tria.cpp) used in that case
		end % }}}
		function marshall(self,md,fid) % {{{

			yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBd18opddEnum(),'format','Integer');

			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','ismungsm','format','Boolean');
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','isd18opd','format','Boolean');
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','desfac','format','Double');
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','s0p','format','Double');
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','s0t','format','Double');
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','rlaps','format','Double');
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','rlapslgm','format','Double');
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','Tdiff','format','DoubleMat','mattype',1,'timeserieslength',2);
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','sealev','format','DoubleMat','mattype',1,'timeserieslength',2);

			if self.isd18opd
				WriteData(fid,'object',self,'class','surfaceforcings','fieldname','temperatures_presentday','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1);
				WriteData(fid,'object',self,'class','surfaceforcings','fieldname','precipitations_presentday','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1);
				WriteData(fid,'object',self,'class','surfaceforcings','fieldname','delta18o','format','DoubleMat','mattype',1,'timeserieslength',2);
				WriteData(fid,'object',self,'class','surfaceforcings','fieldname','dpermil','format','Double');
			end
		end % }}}
	end
end
