import numpy
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import checkfield
from WriteData import WriteData
from project3d import project3d

class SMBd18opdd(object):
	"""
	SMBd18opdd Class definition

	   Usage:
	      SMBd18opdd=SMBd18opdd();
	"""

	def __init__(self): # {{{
		self.desfac                    = 0.
		self.s0p                       = 0.
		self.s0t                       = 0.
		self.rlaps                     = 0.
		self.rlapslgm                  = 0.
		self.dpermil                   = 0.
		self.Tdiff                     = float('NaN')
		self.sealev                    = float('NaN')
		self.ismungsm                  = 0
		self.isd18opd                  = 0
		self.delta18o                  = float('NaN')
		self.delta18o_surface          = float('NaN')
		self.temperatures_presentday   = float('NaN')
		self.precipitations_presentday = float('NaN')

		#set defaults
		self.setdefaultparameters()
		#}}}
	def __repr__(self): # {{{
		string="   surface forcings parameters:"

		string="%s\n%s"%(string,fielddisplay(self,'isd18opd','is delta18o parametrisation from present day temperature and precipitation activated (0 or 1, default is 0)'))
		string="%s\n%s"%(string,fielddisplay(self,'desfac','desertification elevation factor (between 0 and 1, default is 0.5) [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'s0p','should be set to elevation from precip source (between 0 and a few 1000s m, default is 0) [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'s0t','should be set to elevation from temperature source (between 0 and a few 1000s m, default is 0) [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'rlaps','present day lapse rate [degree/km]'))
		if self.isd18opd:
			string="%s\n%s"%(string,fielddisplay(self,'temperatures_presentday','monthly present day surface temperatures [K], required if delta18o/mungsm is activated'))
			string="%s\n%s"%(string,fielddisplay(self,'precipitations_presentday','monthly surface precipitation [m/yr water eq], required if delta18o or mungsm is activated'))
			string="%s\n%s"%(string,fielddisplay(self,'delta18o','delta18o [per mil], required if pdd is activated and delta18o activated'))
			string="%s\n%s"%(string,fielddisplay(self,'dpermil','degree per mil, required if d18opd is activated'))

		return string
		#}}}
	def extrude(self,md): # {{{

		if self.isd18opd: self.temperatures_presentday=project3d(md,'vector',self.temperatures_presentday,'type','node')
		if self.isd18opd: self.precipitations_presentday=project3d(md,'vector',self.precipitations_presentday,'type','node')
		return self
	#}}}
	def initialize(self,md): # {{{

		# if numpy.all(numpy.isnan(self.precipitation)):
		# 	self.precipitation=numpy.zeros((md.mesh.numberofvertices,1))
		# 	print "      no SMBpdd.precipitation specified: values set as zero"
		# 
		 return self
	#}}}
	def setdefaultparameters(self): # {{{

		#pdd method not used in default mode
		self.ismungsm   = 0
		self.isd18opd   = 1
		self.desfac     = 0.5
		self.s0p        = 0.
		self.s0t        = 0.
		self.rlaps      = 6.5 
		self.rlapslgm   = 6.5
		self.dpermil    = 2.4

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		if MasstransportAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.desfac','<=',1,'numel',[1])
			md = checkfield(md,'fieldname','surfaceforcings.s0p','>=',0,'numel',[1])
			md = checkfield(md,'fieldname','surfaceforcings.s0t','>=',0,'numel',[1])
			md = checkfield(md,'fieldname','surfaceforcings.rlaps','>=',0,'numel',[1])
			md = checkfield(md,'fieldname','surfaceforcings.rlapslgm','>=',0,'numel',[1])

			if self.isd18opd:
				md = checkfield(md,'fieldname','surfaceforcings.temperatures_presentday','size',[md.mesh.numberofvertices+1,12],'NaN',1)
				md = checkfield(md,'fieldname','surfaceforcings.precipitations_presentday','size',[md.mesh.numberofvertices+1,12],'NaN',1)
				md = checkfield(md,'fieldname','surfaceforcings.delta18o','NaN',1)
				md = checkfield(md,'fieldname','surfaceforcings.dpermil','>=',0,'numel',[1])

		return md
	# }}}
	def marshall(self,md,fid):    # {{{

		yts=365.0*24.0*3600.0

		WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBd18opddEnum(),'format','Integer')

		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','ismungsm','format','Boolean')
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','isd18opd','format','Boolean')
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','desfac','format','Double')
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','s0p','format','Double')
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','s0t','format','Double')
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','rlaps','format','Double')
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','rlapslgm','format','Double')
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','Tdiff','format','DoubleMat','mattype',1,'timeserieslength',2)
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','sealev','format','DoubleMat','mattype',1,'timeserieslength',2)

		if self.isd18opd:
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','temperatures_presentday','format','DoubleMat','mattype',1)
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','precipitations_presentday','format','DoubleMat','mattype',1)
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','delta18o','format','DoubleMat','mattype',1,'timeserieslength',2)
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','dpermil','format','DoubleMat','mattype',1)
	# }}}
