/*!\file:  ProcessArguments.cpp
 * \brief: process arguments
 */ 

#include <stdio.h>
#include <cstring>

#include "../shared/shared.h"

void ProcessArguments(int* solution_type,char** pbinfilename,char** poutbinfilename,char** ptoolkitsfilename,char** plockfilename,char** prestartfilename, char** prootpath, int argc,char **argv){

	char *modelname      = NULL;
	char *binfilename    = NULL;
	char *outbinfilename = NULL;
	char *toolkitsfilename  = NULL;
	char *lockfilename   = NULL;
	char *restartfilename    = NULL;
	char *rootpath       = NULL;
	char *rootpatharg    = NULL; 
	int   my_rank, rank_length;  

	/*Check input arguments*/
	if(argc<2)_error_("Usage error: no solution requested");
	if(argc<3)_error_("Usage error: missing execution directory");
	if(argc<4)_error_("Usage error: missing model name");

	/*Recover myrank: */
	my_rank=IssmComm::GetRank();
	rank_length= (my_rank == 0 ? 1 : (int)(log10(static_cast<double>(my_rank))+1)); /*length of string "my_rank" */

	/*Get requested solution*/
	*solution_type=StringToEnumx(argv[1]);

	rootpatharg=argv[2];
	if(strcmp(strstr(rootpatharg,"/"),"/")!=0){ 
		rootpath       = xNew<char>(strlen(rootpatharg)+2); sprintf(rootpath,"%s/",rootpatharg);
	}
	else{
		rootpath       = xNew<char>(strlen(rootpatharg)+1); sprintf(rootpath,"%s",rootpatharg);
	}

	modelname=argv[3];
	if(strstr(modelname,rootpath)==NULL){
		binfilename    = xNew<char>(strlen(rootpath)+strlen(modelname)+strlen(".bin")   +1); sprintf(binfilename,   "%s%s%s",rootpath,modelname,".bin");
		outbinfilename = xNew<char>(strlen(rootpath)+strlen(modelname)+strlen(".outbin")+1); sprintf(outbinfilename,"%s%s%s",rootpath,modelname,".outbin");
		toolkitsfilename  = xNew<char>(strlen(rootpath)+strlen(modelname)+strlen(".toolkits") +1); sprintf(toolkitsfilename, "%s%s%s",rootpath,modelname,".toolkits");
		lockfilename   = xNew<char>(strlen(rootpath)+strlen(modelname)+strlen(".lock")  +1); sprintf(lockfilename,  "%s%s%s",rootpath,modelname,".lock");
		restartfilename   = xNew<char>(strlen(rootpath)+strlen(modelname)+strlen(".rst.")  +rank_length +1); sprintf(restartfilename,  "%s%s%s%i",rootpath,modelname,".rst.",my_rank);
	}
	else{
		binfilename    = xNew<char>(strlen(modelname)+strlen(".bin")   +1); sprintf(binfilename,   "%s%s",modelname,".bin");
		outbinfilename = xNew<char>(strlen(modelname)+strlen(".outbin")+1); sprintf(outbinfilename,"%s%s",modelname,".outbin");
		toolkitsfilename  = xNew<char>(strlen(modelname)+strlen(".toolkits") +1); sprintf(toolkitsfilename, "%s%s",modelname,".toolkits");
		lockfilename   = xNew<char>(strlen(modelname)+strlen(".lock")  +1); sprintf(lockfilename,  "%s%s",modelname,".lock");
		restartfilename   = xNew<char>(strlen(modelname)+strlen(".rst.")  +rank_length +1); sprintf(restartfilename,  "%s%s%i",modelname,".rst.",my_rank);
	}

	/*Clean up and assign output pointer*/
	*pbinfilename=binfilename;
	*poutbinfilename=outbinfilename;
	*ptoolkitsfilename=toolkitsfilename;
	*plockfilename=lockfilename;
	*prestartfilename=restartfilename;
	*prootpath=rootpath;

}
