/*\file Marshalling.h
 *\brief: macros to help automate the marshalling, demarshalling, and marshalling size routines. 
 */

#ifndef _MARSHALLING_H_
#define _MARSHALLING_H_

enum marshall_directions{
	MARSHALLING_FORWARD,
	MARSHALLING_BACKWARDS
};

#define MARSHALLING_ENUM(EN) \
	int enum_type=EN; \
	if(marshall_direction==MARSHALLING_FORWARD){\
		if(pmarshalled_data){\
			memcpy(*pmarshalled_data,&enum_type,sizeof(int));\
			*pmarshalled_data+=sizeof(int);\
		}\
		*pmarshalled_data_size+=sizeof(int);\
	}

#define MARSHALLING(FIELD) \
\
	if(marshall_direction==MARSHALLING_FORWARD){\
		if(pmarshalled_data){\
			memcpy(*pmarshalled_data,&FIELD,sizeof(FIELD));\
			*pmarshalled_data+=sizeof(FIELD);\
		}\
		*pmarshalled_data_size+=sizeof(FIELD);\
	}\
	else{\
		memcpy(&FIELD,*pmarshalled_data,sizeof(FIELD));\
		*pmarshalled_data+=sizeof(FIELD);\
	}

#define MARSHALLING_ARRAY(FIELD,TYPE,SIZE) \
\
	if(marshall_direction==MARSHALLING_FORWARD){\
		if(pmarshalled_data){\
			memcpy(*pmarshalled_data,FIELD,SIZE*sizeof(TYPE));\
			*pmarshalled_data+=SIZE*sizeof(TYPE);\
		}\
		*pmarshalled_data_size+=SIZE*sizeof(TYPE);\
	}\
	else{\
		memcpy(FIELD,*pmarshalled_data,SIZE*sizeof(TYPE));\
		*pmarshalled_data+=SIZE*sizeof(TYPE);\
	}

#define MARSHALLING_DYNAMIC(FIELD,TYPE,SIZE) \
\
	if(marshall_direction==MARSHALLING_FORWARD){\
		if(pmarshalled_data){\
			memcpy(*pmarshalled_data,FIELD,SIZE*sizeof(TYPE));\
			*pmarshalled_data+=SIZE*sizeof(TYPE);\
		}\
		*pmarshalled_data_size+=SIZE*sizeof(TYPE);\
	}\
	else{\
		FIELD=xNew<TYPE>(SIZE);\
		memcpy(FIELD,*pmarshalled_data,SIZE*sizeof(TYPE));\
		*pmarshalled_data+=SIZE*sizeof(TYPE);\
	}

#endif	
