/*! \file Observation.h 
 *  \brief: header file for Observation object
 */

#ifndef _OBSERVATION_H_
#define _OBSERVATION_H_

#include "../../datastructures/datastructures.h"

class Observation: public Object{

	public:
		double x,y;
		int    xi,yi;
		int    index;
		double weight;
		double value;

		/*Observation constructors, destructors*/
		Observation();
		Observation(double x_in,double y_in,int xi_in,int yi_in,int index_in,double value_in);
		Observation(double x_in,double y_in,double value_in);
		~Observation();

		/*Object virtual functions definitions*/
		double  distance(const Observation& ob) const;

		void    Echo();
		void    print() const;
		void    DeepEcho()  {_error_("Not implemented yet"); };
		int     Id()        {_error_("Not implemented yet"); };
		int     ObjectEnum(){_error_("Not implemented yet"); };
		bool operator==(const Observation& ob) const;
		Object *copy();
		void Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){ _error_("not implemented yet!");};


		/*Management*/
		void WriteXYObs(const Observation& ob, double* px, double* py, double* pobs);
		void WriteXYObs(double* px,double* py,double* pobs);
};
#endif  /* _OBSERVATION_*/
