#Test Name: SquareShelfLevelsetMeltingSSA2d
from model import *
from triangle import *
from squaremesh import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *
import numpy

md=triangle(model(),'../Exp/Square.exp',50000.)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelf.py')
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)

x = md.mesh.x
xmin = min(x)
xmax = max(x)
Lx = (xmax-xmin)
alpha = 2./3.
md.mask.ice_levelset = numpy.float_((x - alpha*Lx)>0) - numpy.float_((x - alpha*Lx)<0)

md.timestepping.time_step=10
md.timestepping.final_time=30



#Transient
md.transient.isstressbalance=True
md.transient.islevelset=True
md.transient.ismasstransport=True
md.transient.isthermal=False
md.transient.isgroundingline=False
md.transient.isgia=False
md.transient.iscalving=True;

md.calving.calvingrate=numpy.zeros((md.mesh.numberofvertices,1))
md.calving.meltingrate=10000*numpy.ones((md.mesh.numberofvertices,1))
md.calving.spclevelset=numpy.float('NaN')*numpy.ones((md.mesh.numberofvertices,1))

md=solve(md,TransientSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx1','Vy1','Vel1','Pressure1','Thickness1','Surface1','MaskIceLevelset1',\
		'Vx2','Vy2','Vel2','Pressure2','Thickness2','Surface2','MaskIceLevelset2',\
		'Vx3','Vy3','Vel3','Pressure3','Thickness3','Surface3','MaskIceLevelset3']
field_tolerances=[1e-11,1e-11,1e-11,1e-11,1e-11,1e-11,1e-11,\
		2e-11,2e-11,2e-11,1e-11,1e-11,1e-11,5e-11,\
		2e-11,2e-11,2e-11,1e-11,1e-11,1e-11,5e-11]
field_values=[\
	md.results.TransientSolution[0].Vx,\
	md.results.TransientSolution[0].Vy,\
	md.results.TransientSolution[0].Vel,\
	md.results.TransientSolution[0].Pressure,\
	md.results.TransientSolution[0].Thickness,\
	md.results.TransientSolution[0].Surface,\
	md.results.TransientSolution[0].MaskIceLevelset,\
	md.results.TransientSolution[1].Vx,\
	md.results.TransientSolution[1].Vy,\
	md.results.TransientSolution[1].Vel,\
	md.results.TransientSolution[1].Pressure,\
	md.results.TransientSolution[1].Thickness,\
	md.results.TransientSolution[1].Surface,\
	md.results.TransientSolution[1].MaskIceLevelset,\
	md.results.TransientSolution[2].Vx,\
	md.results.TransientSolution[2].Vy,\
	md.results.TransientSolution[2].Vel,\
	md.results.TransientSolution[2].Pressure,\
	md.results.TransientSolution[2].Thickness,\
	md.results.TransientSolution[2].Surface,\
	md.results.TransientSolution[2].MaskIceLevelset,\

	]
