function md=loadresultsfromdisk(md,filename)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%check number of inputs/outputs
if ((nargin~=2) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end

%load result onto model
if ~isstruct(md.results),
	md.results=struct();
end

structure=parseresultsfromdisk(filename);
md.results.(structure.analysis_type)=structure;

%Check result is consistent, only if it exists
disp(sprintf('%s\n','checking result consistency'));
%if ~isresultconsistent(md,md.analysis_type),
%	%it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
%	disp('!! results not consistent correct the model !!') 
%end

%convert analysis type to string
md.analysis_type=AnalysisTypeFromEnum(md.analysis_type);
md.sub_analysis_type=AnalysisTypeFromEnum(md.sub_analysis_type);

%post processes qmu results if necessary
if md.qmu_analysis,
	md=postqmu(md);
	cd ..
end
