function [md analysis_type sub_analysis_type packagefinal]=testsparameterization(md,solution,package)
%TESTSPARAMETERIZATION - build the analysis type and sub analysis type from a string
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input string 'thermalsteady', it will output [thermal steady]
%
%   Usage:
%      [md analysis_type sub_analysis_type packagefinal]=testsparameterization(md,solution,package)
%
%   Example:
%      [md analysis_type sub_analysis_type packagefinal]=testsparameterization(md,'diagnostic','cielo_serial')
%
%   See also: TESTSGETFIELDS

%prepare analysis and parameterize model
if strcmpi(solution,'diagnostic'),
	analysis_type='diagnostic';
	sub_analysis_type='none';

elseif strcmpi(solution,'prognostic'),
	analysis_type='prognostic';
	sub_analysis_type='none';

elseif strcmpi(solution,'thermal_steady'),
	analysis_type='thermal';
	sub_analysis_type='none';
	md.dt=0;

elseif strcmpi(solution,'thermalt_ransient'),
	analysis_type='thermal';
	sub_analysis_type='none';

elseif strcmpi(solution,'transient'),
	sub_analysis_type='none';
	analysis_type='transient';

elseif strcmpi(solution,'steadystate'),
	sub_analysis_type='none';
	analysis_type='steadystate';

elseif (strncmpi(solution,'diagnostic_',11) |  strncmpi(solution,'steadystate_',12)),

	%activate control method, 
	md.control_analysis=1;

	%1: get fit
	solution2=strsplit(solution,'_');
	if strcmpi(solution2{2},'absolute'),
		md.fit(:)=0;
	elseif strcmpi(solution2{2},'relative'),
		md.fit(:)=1;
	elseif strcmpi(solution2{2},'logarithmic'),
		md.fit(:)=2;
	else
		error(['testsparameterization error message: solution2 ' solution2{2} ' not supported yet']);
	end

	%2: get analysis types
	if strcmpi(solution2{1},'diagnostic'),
		analysis_type='diagnostic';
		sub_analysis_type='none';
	else
		analysis_type='steadystate';
		sub_analysis_type='none';
	end

else
	error(['testsparameterization error message: solution '  solution ' not supported yet']);
end

%prepare packagefinal
if strcmpi(package,'ice'),
	packagefinal='ice';

elseif strcmpi(package,'macayeal'),
	packagefinal='macayeal';

elseif strcmpi(package,'cielo_serial'),
	packagefinal='cielo';
	md.cluster='none';

elseif strcmpi(package,'cielo_parallel'),
	packagefinal='cielo';
	md.cluster=oshostname;
	%check and modify number of cpus if necessary
	np=feature('numCores');
	if np<md.np;
		disp(['testsgetpackagefinal warning: changing number of cpus to ' num2str(np) ]);
		md.np=np;
	end

else
	error(['testsparameterization error message: packagefinal '  package ' not supported yet']);
end
