#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.1-p7 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-3.1-p7.tar.gz' 'petsc-3.1-p7.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.1-p7.tar.gz
mv petsc-3.1-p7/* src/
rm -rf petsc-3.1-p7

export PETSC_DIR=`cygpath -u "$ISSM_DIR/externalpackages/petsc/src"`
export PREFIX_DIR=`cygpath -u "$ISSM_DIR/externalpackages/petsc/install"`


# Version 3.1 of Petsc is really old. As such, it is likely that newer machines
# will not be recognized. As such, the build will fail during configuration.
# This can be resolved by simply updated the scripts 'config.guess' and 
# 'config.sub'.
cp ./../autotools/install/share/libtool/config/config.guess ./src/config/configarch/
cp ./../autotools/install/share/libtool/config/config.guess ./src/config/BuildSystem/config/packages/
cp ./../autotools/install/share/libtool/config/config.sub ./src/config/configarch/
cp ./../autotools/install/share/libtool/config/config.sub ./src/config/BuildSystem/config/packages/

#configure
cd src
./config/configure.py  \
	--with-parallel-no \
	--prefix=$PREFIX_DIR \
	--PETSC_ARCH=cygwin-intel \
	--PETSC_DIR=$PETSC_DIR \
	--with-debugging=0 \
	--with-mpi=0 \
	--download-c-blas-lapack=yes \
	--with-cc='win32fe cl' \
	--with-fc=0 \
	--with-cxx='win32fe cl' \
	--with-clanguage=cxx 

#./config/configure.py  \
# --prefix="$ISSM_DIR/externalpackages/petsc/install" \
# --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
# --PETSC_ARCH=macosx-gnu \
# --with-mpi-dir=$ISSM_DIR/externalpackages/mpich/install \
# --with-debugging=0 \
# --with-shared=0 \
# --download-mumps=yes \
# --download-scalapack=yes \
# --download-blacs=yes \
# --download-blas=yes \
# --download-f-blas-lapack=yes \
# --download-plapack=yes \
# --FFLAGS="-I$ISSM_DIR/externalpackages/mpich/install/include -arch i386" \
# --COPTFLAGS="-march=opteron -O2 -arch i386" \
# --FOPTFLAGS="-march=opteron -O2 -arch i386" \
# --CXXOPTFLAGS="-march=opteron -O2 -arch i386" \
# --download-parmetis=yes

#Compile petsc and install it
make
make install

patch ../install/include/petscfix.h ../configs/3.1/win7/petscfix.h.patch
