#Test Name: SquareSheetShelfL1L2
import numpy
from model import *
from EnumDefinitions import *
from MatlabFuncs import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'../Exp/SquareShelf.exp','')
md=parameterize(md,'../Par/SquareSheetShelf.py')
md.extrude(4,1.)
md=setflowequation(md,'L1L2','all')
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,StressbalanceSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vz','Vel','Pressure']
field_tolerances=[1e-06,1e-06,1e-06,1e-06,1e-07]
field_values=[\
	md.results.StressbalanceSolution.Vx,\
	md.results.StressbalanceSolution.Vy,\
	md.results.StressbalanceSolution.Vz,\
	md.results.StressbalanceSolution.Vel,\
	md.results.StressbalanceSolution.Pressure,\
	]
