function md=radarpower(md,varargin)
%RADARPOWER - overlay a power radar image on an existing mesh
%
%   This routine will overlay a power radar image on an existing mesh.
%   The power amplitude will be output to vel for now.
%   In the future, think about a field to hold this value.
%
%   Usage:
%      md=radarpower(md,options);
%      md=radarpower(md)

%Parse inputs
if nargin==1,
	options=pairoptions;
else
	options=varargin{:};
	if ~isa(options,'pairoptions'),
		options=pairoptions(varargin{:});
	end
end

geotiff_name = getfieldvalue(options,'geotiff_name','');
highres = getfieldvalue(options,'highres',0);
xlim    = getfieldvalue(options,'xlim',[min(md.mesh.x) max(md.mesh.x)]);
ylim    = getfieldvalue(options,'ylim',[min(md.mesh.y) max(md.mesh.y)]);
posting = getfieldvalue(options,'posting',0); % 0 -> image posting default
a = getfieldvalue(options,'overlay_adjust_a',0);
b = getfieldvalue(options,'overlay_adjust_b',1);
c = getfieldvalue(options,'overlay_adjust_c',0);
d = getfieldvalue(options,'overlay_adjust_d',1);

%find gdal coordinates
x0=min(xlim); x1=max(xlim);
y0=min(ylim); y1=max(ylim);

%figure out if we should go look for Greenland or Antarctica geotiff, or if user provided one.
if ~exist(options,'overlay_image'),
	if md.mesh.epsg==3413,
		%if ~exist(['/u/astrid-r1b/ModelData/MOG/mog150_greenland_map.jpg']),
		%	error(['radarpower error message: file ' '/u/astrid-r1b/ModelData/MOG/mog150_greenland_map.jpg not found.']);
		%end
		%name = 'mog150_greenland_map';
		%name = 'mog100_hp1_v10';
		%%name = 'mog500_hp1_v10';
		%jpgim=['/u/astrid-r1b/ModelData/MOG/' name '.jpg'];
		%geom=load(['/u/astrid-r1b/ModelData/MOG/' name '.jpgw'],'ascii');
		%%jpgim='/u/astrid-r1b/morlighe/issmjpl/projects/MorlighemGRL2012/Data/Mosaic_amp_asar2010.jpg';
		%%geom=load('/u/astrid-r1b/morlighe/issmjpl/projects/MorlighemGRL2012/Data/Mosaic_amp_asar2010.jpgw');
		%jpgim='/u/astrid-r1b/morlighe/issmjpl/projects/MorlighemGRL2012/Data/Russel_asar2010.png';
		%geom=load('/u/astrid-r1b/morlighe/issmjpl/projects/MorlighemGRL2012/Data/Russel_asar2010.pngw');

		%%geom:   xposting nbcols nbrows yposting xmin ymax
		%xmin=max(geom(5),x0);
		%xmax=min(geom(5)+geom(1)*geom(2),x1);
		%ymin=max(geom(6)-geom(3)*geom(4),y0);
		%ymax=min(geom(6),y1);

		%firstcol=max(1,floor((xmin-geom(5))/geom(1))); %x min
		%firstrow=max(1,floor((geom(6)-ymax)/geom(4))); %y max
		%numcols=floor((xmax-xmin)/geom(1)); % x posting
		%numrows=floor((ymax-ymin)/geom(4)); % y posting
		%pixelskip=max(1,ceil(posting/geom(1)));

		%%Read and crop file
		%disp('Warning: expecting coordinates in polar stereographic (Std Latitude: 70ºN Meridian: 45º)');
		%im=imread(jpgim);
		%im=im(firstrow:firstrow+numrows-1,firstcol:firstcol+numcols-1);
		%md.radaroverlay.pwr=double(flipud(im(1:pixelskip:end,1:pixelskip:end)));
		%md.radaroverlay.x=(xmin:(xmax-xmin)/(size(md.radaroverlay.pwr,2)-1):xmax);
		%md.radaroverlay.y=(ymin:(ymax-ymin)/(size(md.radaroverlay.pwr,1)-1):ymax);
		if ~exist(options,'geotiff_name'),
			if highres,
				if ~exist(['/u/astrid-r1b/ModelData/MOG/mog100_r2_hp1.tif']),
					error(['radarpower error message: file ' '/u/astrid-r1b/ModelData/MOG/mog100_r2_hp1.tif not found.']);
				end
				geotiff_name=['/u/astrid-r1b/ModelData/MOG/mog100_r2_hp1.tif'];
			else
				if ~exist(['/u/astrid-r1b/ModelData/MOG/mog500_r2_hp1.tif']),
					error(['radarpower error message: file ' '/u/astrid-r1b/ModelData/MOG/mog500_r2_hp1.tif not found.']);
				end
				geotiff_name=['/u/astrid-r1b/ModelData/MOG/mog500_r2_hp1.tif'];
			end
		end

		%Name of image
		inputname='./temp.tif';
		eval(['!gdal_translate -quiet -projwin ' num2str(x0) ' ' num2str(y1) ' ' num2str(x1) ' ' num2str(y0) ' ' geotiff_name ' ' inputname ]);

		%Read in temp.tif:
		im=imread('temp.tif','TIFF');
		%adjust contrast and brightness
		%im=imadjust(im,[a b],[c d]);
		pixelskip=max(1,ceil(posting/((x1-x0)/(size(im,2)))));
		if size(im,3)==1,
			md.radaroverlay.pwr=double(flipud(im(1:pixelskip:end,1:pixelskip:end)));
		else
			md.radaroverlay.pwr=double(im(1:pixelskip:end,1:pixelskip:end,1:pixelskip:end));
			md.radaroverlay.pwr(:,:,1)=flipud(md.radaroverlay.pwr(:,:,1));
			md.radaroverlay.pwr(:,:,2)=flipud(md.radaroverlay.pwr(:,:,2));
			md.radaroverlay.pwr(:,:,3)=flipud(md.radaroverlay.pwr(:,:,3));
		end
		md.radaroverlay.x=(x0:(x1-x0)/(size(md.radaroverlay.pwr,2)-1):x1);
		md.radaroverlay.y=(y0:(y1-y0)/(size(md.radaroverlay.pwr,1)-1):y1);

		%Erase image
		system('rm -rf ./temp.tif');

	elseif md.mesh.epsg==3031,
		if ~exist(options,'geotiff_name'),
			if highres,
				if ~exist(['/u/astrid-r1b/ModelData/MosaicTiffRsat/amm125m_v2_200m.tif']),
					error(['radarpower error message: file ' '/u/astrid-r1b/ModelData/MosaicTiffRsat/amm125m_v2_200m.tif not found.']);
				end
				geotiff_name=['/u/astrid-r1b/ModelData/MosaicTiffRsat/amm125m_v2_200m.tif'];
			else
				if ~exist(['/u/astrid-r1b/ModelData/MosaicTiffRsat/amm125m_v2_1km.tif']),
					error(['radarpower error message: file ' '/u/astrid-r1b/ModelData/MosaicTiffRsat/amm125m_v2_1km.tif not found.']);
				end
				geotiff_name=['/u/astrid-r1b/ModelData/MosaicTiffRsat/amm125m_v2_1km.tif'];
			end
		end

		%Name of image
		inputname='./temp.tif';
		eval(['!gdal_translate -quiet -projwin ' num2str(x0) ' ' num2str(y1) ' ' num2str(x1) ' ' num2str(y0) ' ' geotiff_name ' ' inputname ]);

		%Read in temp.tif:
		im=imread('temp.tif','TIFF');
		%adjust contrast and brightness
		%im=imadjust(im,[a b],[c d]);
		pixelskip=max(1,ceil(posting/((x1-x0)/(size(im,2)))));
		md.radaroverlay.pwr=double(flipud(im(1:pixelskip:end,1:pixelskip:end)));
		md.radaroverlay.x=(x0:(x1-x0)/(size(md.radaroverlay.pwr,2)-1):x1);
		md.radaroverlay.y=(y0:(y1-y0)/(size(md.radaroverlay.pwr,1)-1):y1);

		%Erase image
		system('rm -rf ./temp.tif');

	else
		error('EPSG code not supported yet (ex: 3413 for UPS Greenland, 3031 for UPS Antarctica)');
	end
else
	%user provided an image. check we also have overlay_xlim and overlay_ylim  options, to know what range of coordinates the image covers.
	if (~exist(options,'overlay_xlim') | ~exist(options,'overlay_xlim')| ~exist(options,'overlay_xposting')| ~exist(options,'overlay_yposting')),
		error('radarpower error message: please provide overlay_xlim, overlay_ylim, overlay_xposting and overlay_yposting options together with overlay_image option');
	end
	overlay_image=getfieldvalue(options,'overlay_image');
	overlay_xlim=getfieldvalue(options,'overlay_xlim');
	overlay_ylim=getfieldvalue(options,'overlay_ylim');
	overlay_xposting=getfieldvalue(options,'overlay_xposting');
	overlay_yposting=getfieldvalue(options,'overlay_yposting');

	sizex=floor((x1-x0)/overlay_xposting);
	sizey=floor((y1-y0)/overlay_yposting);
	topleftx=floor((x0-overlay_xlim(1))/overlay_xposting); % x min
	toplefty=floor((overlay_ylim(2)-y1)/overlay_yposting); % y max

	%Read and crop file
	disp('Warning: expecting coordinates in polar stereographic (Std Latitude: 70ºN Meridian: 45º)');
	im=imread(overlay_image);
	%adjust contrast and brightness
	%im=imadjust(im,[a b],[c d]);
	im=im(toplefty:toplefty+sizey,topleftx:topleftx+sizex);
	md.radaroverlay.pwr=double(flipud(im));
	md.radaroverlay.x=(x0:(x1-x0)/(size(md.radaroverlay.pwr,2)-1):x1);
	md.radaroverlay.y=(y0:(y1-y0)/(size(md.radaroverlay.pwr,1)-1):y1);
end
