%MASSFLUXATGATE class definition
%
%   Usage:
%      massfluxatgate=massfluxatgate();
%      massfluxatgate=massfluxatgate('name','GateName','definitionname',Outputdefinition1Enum,'profilename','PathToExpFile');

classdef massfluxatgate
	properties (SetAccess=public)  
		%massfluxatgate 
		name            = '';
		definitionenum  = 0;
		profilename     = ''; 
	end
	properties (SetAccess=private)  
		segments        = NaN;
	end
	methods
		function self = massfluxatgate(varargin) % {{{
			if nargin==0,
				self=setdefaultparameters(self);
			else
				%use provided options to change fields
				options=pairoptions(varargin{:});

				%get name
				self.name=getfieldvalue(options,'name','');
				self.definitionenum=getfieldvalue(options,'definitionenum');
				self.profilename=getfieldvalue(options,'profilename');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{
			
			if ~ischar(self.name),
				error('massfluxatgate error message: ''name'' field should be a string!');
			end
			if ~ischar(self.profilename),
				error('massfluxatgate error message: ''profilename'' field should be a string!');
			end
			
			md = checkfield(md,'field',self.definitionenum,'values',[Outputdefinition1Enum():Outputdefinition100Enum()]);

			%check the profilename points to a file!: 
			if exist(self.profilename,'file')~=2,
				error('massfluxatgate error message: file name for profile corresponding to gate does not point to a legitimate file on disk!');
			end
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   Massfluxatgate:\n'));

			fielddisplay(self,'name','identifier for this massfluxatgate response');
			fielddisplay(self,'profilename','name of file (shapefile or argus file) defining a profile (or gate)');
			fielddisplay(self,'definitionenum','enum that identifies this output definition uniquely, from Outputdefinition[1-10]Enum');
			
		end % }}}
		function marshall(self,md,fid) % {{{

		%before marshalling, we need to create the segments out of the profilename: 
		self.segments=MeshProfileIntersection(md.mesh.elements,md.mesh.x,md.mesh.y,self.profilename);

		%ok, marshall name and segments: 
		WriteData(fid,'object',self,'fieldname','name','format','String');
		WriteData(fid,'object',self,'fieldname','definitionenum','format','Integer');
		WriteData(fid,'object',self,'fieldname','segments','format','DoubleMat','mattype',1);

		end % }}}
	end
end
