%CONSTANTS class definition
%
%   Usage:
%      constants=constants();

classdef constants
	properties (SetAccess=public) 
		g                    = 0.;
		omega                = 0.;
		yts                  = 0.;
		referencetemperature = 0.;
	end
	methods
        function createxml(self,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- constants -->');
			 fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','<parameter key ="g" type="',class(self.g),'" default="',num2str(self.g),'">','     <section name="constants" />','     <help> gravitational acceleration [m/s^2] </help>','</parameter>');
             fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','<parameter key ="yts" type="',class(self.yts),'" default="',num2str(self.yts),'">','     <section name="constants" />','     <help> number of seconds in a year [s/yr] </help>','</parameter>');
             fprintf(fid,'%s%s%s%s%s\n%s\n%s\n','<parameter key ="referencetemperature" type="',class(self.referencetemperature),'" default="',num2str(self.referencetemperature),'">','     <section name="constants" />','     <help> reference temperature used in the enthalpy model [K] </help>','</parameter>');
		end % }}}
		function self = constants(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{

			%acceleration due to gravity (m/s^2)
			self.g=9.81;

			%Earth's rotation speed 
			self.omega = 7.292*1e-5;

			%converstion from year to seconds
			self.yts=365*24*3600;

			%the reference temperature for enthalpy model (cf Aschwanden)
			self.referencetemperature=223.15;

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','constants.g','>=',0,'size',[1 1]); %We allow 0 for validation tests
			md = checkfield(md,'fieldname','constants.omega','>=',0,'size',[1 1]);
			md = checkfield(md,'fieldname','constants.yts','>',0,'size',[1 1]);
			md = checkfield(md,'fieldname','constants.referencetemperature','size',[1 1]);

		end % }}}
		function disp(self) % {{{
			disp(sprintf('   constants parameters:'));

			fielddisplay(self,'g','gravitational acceleration [m/s^2]');
			fielddisplay(self,'omega','angular velocity of Earth [rad/s]');
			fielddisplay(self,'yts','number of seconds in a year [s/yr]');
			fielddisplay(self,'referencetemperature','reference temperature used in the enthalpy model [K]');

		end % }}}
		function marshall(self,md,fid) % {{{
			WriteData(fid,'object',self,'fieldname','g','format','Double');
			WriteData(fid,'object',self,'fieldname','omega','format','Double');
			WriteData(fid,'object',self,'fieldname','yts','format','Double');
			WriteData(fid,'object',self,'fieldname','referencetemperature','format','Double');
		end % }}}
	end
end
