%SMBgradients Class definition
%
%   Usage:
%      SMBgradients=SMBgradients();

classdef SMBgradients
	properties (SetAccess=public) 
		href   = NaN;
		smbref = NaN;
		b_pos  = NaN;
		b_neg  = NaN;
	end
	methods
		function self = SMBgradients(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{

			%Nothing for now

		end % }}}
		function self = initialize(self,md) % {{{

			%Nothing done for now

		end % }}}
		function self = setdefaultparameters(self) % {{{

			%Nothing for now

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.href','timeseries',1,'NaN',1);
				md = checkfield(md,'fieldname','surfaceforcings.smbref','timeseries',1,'NaN',1);
				md = checkfield(md,'fieldname','surfaceforcings.b_pos','timeseries',1,'NaN',1);
				md = checkfield(md,'fieldname','surfaceforcings.b_neg','timeseries',1,'NaN',1);
			end
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   surface forcings parameters:'));

			disp(sprintf('\n   SMB gradients parameters:'));
			fielddisplay(self,'href',' reference elevation from which deviation is used to calculate SMB adjustment in smb gradients method [m]');
			fielddisplay(self,'smbref',' reference smb from which deviation is calculated in smb gradients method [mm/yr water equiv]');
			fielddisplay(self,'b_pos',' slope of hs - smb regression line for accumulation regime required if smb gradients is activated');
			fielddisplay(self,'b_neg',' slope of hs - smb regression line for ablation regime required if smb gradients is activated');

		end % }}}
		function marshall(self,md,fid) % {{{

			yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBgradientsEnum(),'format','Integer');
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','href','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','smbref','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','b_pos','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',self,'class','surfaceforcings','fieldname','b_neg','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1);

		end % }}}
	end
end
