/*! \file ControlInput.h 
 *  \brief: header file for triavertexinput object
 */

#ifndef _CONTROLINPUT_H_
#define _CONTROLINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
class Gauss;
class Gauss;
/*}}}*/

class ControlInput: public Input{

	public:
		int    enum_type;
		int    control_id;
		Input* values;
		Input* savedvalues;
		Input* minvalues;
		Input* maxvalues;
		Input* gradient;

		/*ControlInput constructors, destructors: {{{*/
		ControlInput();
		ControlInput(int enum_type,int enum_input,IssmDouble* pvalues,IssmDouble* pmin,IssmDouble* pmax,int id);
		~ControlInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ControlInput management: {{{*/
		int    InstanceEnum();
		Input* SpawnTriaInput(int index1,int index2,int index3);
		Input* SpawnSegInput(int index1,int index2);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* inputB){_error_("not implemented yet");};
		void AddTimeValues(IssmDouble* values,int step,IssmDouble time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetGradientValue(IssmDouble* pvalue,Gauss* gauss);
		void SetInput(Input* in_input);
		void GetInputValue(bool* pvalue);
		void GetInputValue(int* pvalue);
		void GetInputValue(IssmDouble* pvalue);
		void GetInputValue(IssmDouble* pvalue,Gauss* gauss);
		void GetInputValue(IssmDouble* pvalue,Gauss* gauss,IssmDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,Gauss* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list,Gauss* gauss);
		void GetInputAverage(IssmDouble* pvalue);
		void GetInputAllTimeAverages(IssmDouble** pvalues,IssmDouble** ptimes, int* pnumtimes){_error_("not implemented yet");};
		void GetInputUpToCurrentTimeAverages(IssmDouble** pvalues, IssmDouble** ptimes, int* pnumtimes, IssmDouble currenttime){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype){_error_("not implemented yet");};
		void SquareMin(IssmDouble* psquaremin,Parameters* parameters){_error_("not implemented yet");};
		void ConstrainMin(IssmDouble minimum){_error_("not implemented yet");};
		void Set(IssmDouble setvalue){_error_("Set not implemented yet");};
		void Scale(IssmDouble scale_factor){_error_("not implemented yet");};
		void AXPY(Input* xinput,IssmDouble scalar);
		void Constrain(void);
		void Constrain(IssmDouble min,IssmDouble max);
		IssmDouble InfinityNorm(void){_error_("not implemented yet");};
		IssmDouble Max(void){_error_("not implemented yet");};
		IssmDouble MaxAbs(void){_error_("not implemented yet");};
		IssmDouble Min(void);
		IssmDouble MinAbs(void){_error_("not implemented yet");};
		void Extrude(int start);
		void VerticallyIntegrate(Input* thickness_input);
		void GetVectorFromInputs(Vector<IssmDouble>* vector,int* doflist,const char* data);
		void GetVectorFromInputs(Vector<IssmDouble>* vector,int* doflist);
		int  GetResultInterpolation(void);
		int  GetResultNumberOfNodes(void);
		void ResultToPatch(IssmDouble* values,int nodesperelement,int sid){_error_("not supported yet");};
		void GetGradient(Vector<IssmDouble>* gradient_vec,int* doflist);
		void ScaleGradient(IssmDouble scale);
		void SetGradient(Input* gradient_in);
		void UpdateValue(IssmDouble scalar);
		void SaveValue(void);
		/*}}}*/

};
#endif  /* _CONTROLINPUT_H */
