function [analysis_type sub_analysis_type]=testsgetanalys(string),
%TESTSGETANALYSIS - build the analysis type and sub analysis type from a string
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input string 'thermalsteady', it will output [thermal steady]
%
%   Usage:
%      [analysis_type sub_analysis_type]=testsgetanalysis(string)
%
%   Example:
%      [analysis_type sub_analysis_type]=testsgetanalysis('diagnostic');
%
%   See also: TESTSGETPACKAGE, TESTSGETFIELDS

if strcmpi(string,'diagnostic'),
	analysis_type='diagnostic';
	sub_analysis_type='none';

elseif strcmpi(string,'prognostic'),
	analysis_type='prognostic';
	sub_analysis_type='none';

elseif strcmpi(string,'thermalsteady'),
	analysis_type='thermal';
	sub_analysis_type='none';

elseif strcmpi(string,'thermaltransient'),
	analysis_type='thermal';
	sub_analysis_type='none';

elseif strcmpi(string,'transient'),
	sub_analysis_type='none';
	analysis_type='transient';

elseif strcmpi(string,'steadystate'),
	sub_analysis_type='none';
	analysis_type='steadystate';

else
	error(['testsgetanalysis error message: solution '  string ' not supported yet']);
end
