
function export_netCDF(md,filename)	
	
%Now going on Real treatment
	if exist(filename),
		disp(sprintf('File %s allready exist', filename));
		prompt = 'Give a new name or "delete" to replace: ';
		newname = input(prompt,'s');
		if strcmp(newname,'delete')
			delete(filename)
		else
			disp(sprintf('New file name is %s ', newname));
			filename=newname
	  end
  end
	%open file and write description
	mode = netcdf.getConstant('NETCDF4');
	mode = bitor(mode,netcdf.getConstant('NOCLOBBER'));%NOCLOBBER to avoid overwrite
	ncid = netcdf.create(filename,mode);
	netcdf.putAtt(ncid,netcdf.getConstant('NC_GLOBAL'),'Title',['Results for run ' md.miscellaneous.name]);
	netcdf.putAtt(ncid,netcdf.getConstant('NC_GLOBAL'),'Date',['Created ' datestr(now)]);
	
	%gather geometry and timestepping as dimensions
	Duration=md.timestepping.final_time-md.timestepping.start_time;
	if Duration>0 && md.timestepping.time_step*md.settings.output_frequency>0,
		StepNum=Duration/(md.timestepping.time_step*md.settings.output_frequency);
	else
		StepNum=1;
  end							
 
	%define netcdf dimensions
	DimSize(1).index=netcdf.defDim(ncid,'EltNum',md.mesh.numberofelements);
	DimSize(2).index=netcdf.defDim(ncid,'VertNum',md.mesh.numberofvertices);
	DimSize(3).index=netcdf.defDim(ncid,'VertperElt',size(md.mesh.elements,2));
	
	for i=1:length(DimSize),
		[DimSize(i).name,DimSize(i).value]=netcdf.inqDim(ncid,DimSize(i).index);
		DimValue(i)=DimSize(i).value;% putting vallues in an array for
                                 % further use
  end
 
	%Needs a first turn arround for var def
 
	%get all model classes and create respective groups
	groups=fieldnames(md);
	for i=1:length(groups),
		%disp(sprintf('group name in tree %s ',groups{i}));
		groupID=netcdf.defGrp(ncid,groups{i});
		%In each group gather the fields of the class
		groupfields=fields(md.(groups{i}));
		%Special treatment for the results
		if strcmp(groups(i),'results'),
			for j=1:length(groupfields)%looping on the different solutions
				%disp(sprintf('=====Field name in tree %s ',groupfields{j}));
				if length(md.results.(groupfields{j}))>1,
					%the solution have several timestep get last timesteps and output frequency
					last_step = length(md.results.(groupfields{j}));
					step_freq = md.settings.output_frequency;
					%grab first time step
					subfields=fields(md.results.(groupfields{j})(1));
					for k=1:length(subfields),
						netcdf.putAtt(groupID,netcdf.getConstant('NC_GLOBAL'),'classtype','results');
						if ~strcmp(subfields(k),'errlog') && ~strcmp(subfields(k),'outlog') && ~strcmp(subfields(k),'SolutionType'),
							disp(sprintf('==========SubField name in tree %s ',subfields{k}));
							Var=md.results.(groupfields{1})(1).(subfields{k});
							[truc,DimSize,DimValue]=DefCreateVar(ncid,Var,groupID,subfields{k},DimSize,DimValue);
							%CreateVar(Var,True,last_step,step_freq)
			      end
		      end
				elseif length(md.results.(groupfields{j}))==1,
					%only one timestep
					subfields=fields(md.results.(groupfields{j}));
					for k=1:length(subfields),
						disp(sprintf('==========SubField name in tree %s ',subfields{k}));
						netcdf.putAtt(groupID,netcdf.getConstant('GLOBAL'),'classtype','results');
						if ~strcmp(subfields(k),'errlog') && ~strcmp(subfields(k),'outlog') && ~strcmp(subfields(k),'SolutionType'),
							Var=md.results.(groupfields{1})(1).(subfields{k});
							[truc,DimSize,DimValue]=DefCreateVar(ncid,Var,groupID,subfields{k},DimSize,DimValue);
			      end
		      end
				else
					print 'Result format not suported'
		    end
	    end
		else
			for j=1:length(groupfields),
				disp(sprintf('=====Field name in tree %s ',groupfields{j}));
				netcdf.putAtt(groupID,netcdf.getConstant('GLOBAL'),'classtype',class(md.(groups{i})));
				Var=md.(groups{i}).(groupfields{j});
				[truc,DimSize,DimValue]=DefCreateVar(ncid,Var,groupID,groupfields{j},DimSize,DimValue);
	    end
	  end	
  end
	netcdf.close(ncid);
end

function [varclass,DimSize,DimValue]=DefCreateVar(ncid,Var,groupID,field,DimSize,DimValue)
	varclass=class(Var);
	varsize=size(Var);
	varlength=length(Var);
	if isa(Var,'logical'),
		if Var,
			LogicString='True';
		else,
			LogicString='False';
  	end
		netcdf.putAtt(groupID,netcdf.getConstant('GLOBAL'),field,LogicString);
	elseif isa(Var,'char'),
		netcdf.putAtt(groupID,netcdf.getConstant('GLOBAL'),field,Var);
	elseif isa(Var,'double'), %dealing with arrays
		[dims,DimSize,DimValue]=GetDims(ncid,Var,groupID,field,DimSize,DimValue);
 		varid = netcdf.defVar(groupID,field,'double',dims);
		if length(Var)==0,
			netcdf.putVar(groupID,varid,NaN);
		else
			netcdf.putVar(groupID,varid,Var);
  	end
	elseif isa(Var,'cell'),
		disp(sprintf('no support for class %s for field %s so far',varclass,field));
	elseif isa(Var,'struct'),
		disp(sprintf('no support for class %s for field %s so far',varclass,field));
	else
		disp(sprintf('no support for class %s of field %s',varclass,field));
  end
	return
end

function [dims,DimSize,DimValue]=GetDims(ncid,Var,groupID,field,DimSize,DimValue)
	dims=[];
	varlength=length(Var);
	varsize=size(Var);
	MatOrVec=varsize>1; %checking if we have a matrix (1 1) are vector (1 0)
	for i=1:sum(MatOrVec), %loop on the number of (non 1) dimensions
		currentdim=varsize(i);
		dimexist=DimValue==currentdim;
		if sum(dimexist)==0, %dimension is new to us, need to create it
			dimname=strcat(field,int2str(i));
			dimindex=length(DimSize)+1;
			DimSize(dimindex).index=netcdf.defDim(ncid,dimname,currentdim);
			[DimSize(dimindex).name,DimSize(dimindex).value]=netcdf.inqDim(ncid,DimSize(dimindex).index);
			dims(i)=DimSize(dimindex).index;
			DimValue(dimindex)=currentdim;
		else
			dimindex=find(dimexist);
			if DimSize(dimindex).value~=currentdim,
				error('Indexation problem with the dimension structure')
  	  end
	  end
		dims(i)=DimSize(dimindex).index;
  end
end
