#Test Name: SquareShelfConstrainedMasstransp2dDGAdolcMumps
from model import *
from triangle import *
from meshconvert import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',150000.)
md=meshconvert(md)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)
md.masstransport.stabilization=3
md.masstransport.spcthickness=md.geometry.thickness
md.toolkits.DefaultAnalysis=issmmumpssolver()
md.autodiff.isautodiff=True
md=solve(md,MasstransportSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Thickness']
field_tolerances=[1e-13]
field_values=[\
	md.results.MasstransportSolution.Thickness,\
	]
