function name=IdToName(id);
%IDTONAME- return name of test
%
%   Usage:
%      name=IdToName(id);

filename = ['test' num2str(id) '.m'];

if ~exist(filename,'file')
	error(['file ' filename ' does not exist']);
end

string='%TestName:';
fid=fopen(filename,'r');
A=fscanf(fid,'%s',3);
if ~strncmp(A,string,numel(string)) | numel(A)<numel(string)+2,
	error(['Test file ' filename ' does to start with a test name']);
end
name = A(numel(string)+1:end);
fclose(fid);
