%SEAICE class definition
%
%   Usage:
%      seaice=seaice();

classdef seaice
	properties (SetAccess=public) 
		min_concentration = 0.;
		min_thickness     = 0.;
		max_thickness     = 0.;
		spcvx             = NaN;
		spcvy             = NaN;
		coriolis_factor   = NaN;
	end
	methods
		function self = seaice(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
					return;
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{
			if solution~=SeaiceSolutionEnum(), return; end
			md = checkfield(md,'fieldname','seaice.min_concentration','NaN',1,'>=',0,'numel',1);
			md = checkfield(md,'fieldname','seaice.min_thickness','NaN',1,'>=',0,'numel',1);
			md = checkfield(md,'fieldname','seaice.max_thickness','NaN',1,'>',0,'numel',1);
			md = checkfield(md,'fieldname','seaice.spcvx','size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','seaice.spcvy','size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','seaice.coriolis_factor','size',[md.mesh.numberofelements 1],'NaN',1,'>=',0);
		end % }}}
		function self = setdefaultparameters(self) % {{{

			%Minimum ice concentration allowed in the simulation
			self.min_concentration=0.;

			%Minimum ice thickness allowed in the simulation
			self.min_thickness=0.;

			%Maxmimum ice thickness allowed in the simulation
			self.max_thickness=25.;

		end % }}}
		function disp(self) % {{{
			disp(sprintf('   seaice parameters:'));
			fielddisplay(self,'min_concentration','minimum ice concentration allowed in the simulation [no unit]');
			fielddisplay(self,'min_thickness','minimum ice thickness allowed in the simulation [m]');
			fielddisplay(self,'max_thickness','maximum ice thickness allowed in the simulation [m]');
			fielddisplay(self,'spcvx','x-axis velocity constraint (NaN means no constraint) [m/s]');
			fielddisplay(self,'spcvy','y-axis velocity constraint (NaN means no constraint) [m/s]');
			fielddisplay(self,'coriolis_factor','factor applied to Coriolis forces (latitude dependent)');
		end % }}}
		function marshall(self,md,fid) % {{{
			WriteData(fid,'object',self,'fieldname','min_concentration','format','Double');
			WriteData(fid,'object',self,'fieldname','min_thickness','format','Double');
			WriteData(fid,'object',self,'fieldname','max_thickness','format','Double');
			WriteData(fid,'object',self,'fieldname','spcvx','format','DoubleMat','mattype',1);
			WriteData(fid,'object',self,'fieldname','spcvy','format','DoubleMat','mattype',1);
			WriteData(fid,'object',self,'fieldname','coriolis_factor','format','DoubleMat','mattype',2);
		end % }}}
	end
end
