%SEAICEINITIALIZATION class definition
%
%   Usage:
%      seaiceinitialization=seaiceinitialization();

classdef seaiceinitialization
	properties (SetAccess=public) 
		thickness          = NaN;
		concentration      = NaN;
		vx                 = NaN;
		vy                 = NaN;
		vx_coriolis        = NaN;
		vy_coriolis        = NaN;
		sigma_predictor_xx = NaN;
		sigma_predictor_yy = NaN;
		sigma_predictor_xy = NaN;
		damage             = NaN;
		mesh_x             = NaN;
		mesh_y             = NaN;
	end
	methods
		function self = seaiceinitialization(varargin) % {{{
			switch nargin
				case 0
					return;
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{
			md = checkfield(md,'fieldname','initialization.thickness','size',[md.mesh.numberofelements 1],'NaN',1,'>=',0);
			md = checkfield(md,'fieldname','initialization.concentration','size',[md.mesh.numberofelements 1],'NaN',1,'>=',0);
			md = checkfield(md,'fieldname','initialization.vx','NaN',1,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','initialization.vy','NaN',1,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','initialization.vx_coriolis','NaN',1,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','initialization.vy_coriolis','NaN',1,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','initialization.sigma_predictor_xx','NaN',1,'>=',0,'<',1,'size',[md.mesh.numberofelements 1]);
			md = checkfield(md,'fieldname','initialization.sigma_predictor_yy','NaN',1,'>=',0,'<',1,'size',[md.mesh.numberofelements 1]);
			md = checkfield(md,'fieldname','initialization.sigma_predictor_xy','NaN',1,'>=',0,'<',1,'size',[md.mesh.numberofelements 1]);
			md = checkfield(md,'fieldname','initialization.damage','NaN',1,'>=',0,'<',1,'size',[md.mesh.numberofelements 1]);
			md = checkfield(md,'fieldname','initialization.mesh_x','NaN',1,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','initialization.mesh_y','NaN',1,'size',[md.mesh.numberofvertices 1]);
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   initial field values:'));
			fielddisplay(self,'thickness','sea ice thickness [m]');
			fielddisplay(self,'concentration','sea ice concentration (between 0 and 1)');
			fielddisplay(self,'vx','x component of the ice velocity [m/s]');
			fielddisplay(self,'vy','y component of the ice velocity [m/s]');
			fielddisplay(self,'vx_coriolis','x component of the ice velocity used to calculate coriolis forces [m/s]');
			fielddisplay(self,'vy_coriolis','y component of the ice velocity used to calculate coriolis forces [m/s]');
			fielddisplay(self,'sigma_predictor_xx','Predictor for the xx component of the Cauchy stress tensor [Pa]');
			fielddisplay(self,'sigma_predictor_yy','Predictor for the yy component of the Cauchy stress tensor [Pa]');
			fielddisplay(self,'sigma_predictor_xy','Predictor for the xy component of the Cauchy stress tensor [Pa]');
			fielddisplay(self,'damage','damage, between 0 (no damage) and 1 (fully damaged)');
			fielddisplay(self,'mesh_x','x position of each vertex of the mesh using a Lagrangian approach');
			fielddisplay(self,'mesh_y','y position of each vertex of the mesh using a Lagrangian approach');
		end % }}}
		function marshall(self,md,fid) % {{{
			WriteData(fid,'data',self.thickness,'format','DoubleMat','mattype',2,'enum',SeaiceThicknessEnum());
			WriteData(fid,'data',self.concentration,'format','DoubleMat','mattype',2,'enum',SeaiceConcentrationEnum());
			WriteData(fid,'data',self.vx,'format','DoubleMat','mattype',1,'enum',VxEnum);
			WriteData(fid,'data',self.vy,'format','DoubleMat','mattype',1,'enum',VyEnum);
			WriteData(fid,'data',self.vx_coriolis,'format','DoubleMat','mattype',1,'enum',VxStarEnum());
			WriteData(fid,'data',self.vy_coriolis,'format','DoubleMat','mattype',1,'enum',VyStarEnum());
			WriteData(fid,'data',self.sigma_predictor_xx,'format','DoubleMat','mattype',2,'enum',StressTensorPredictorxxEnum());
			WriteData(fid,'data',self.sigma_predictor_yy,'format','DoubleMat','mattype',2,'enum',StressTensorPredictoryyEnum());
			WriteData(fid,'data',self.sigma_predictor_xy,'format','DoubleMat','mattype',2,'enum',StressTensorPredictorxyEnum());
			WriteData(fid,'data',self.damage,'format','DoubleMat','mattype',2,'enum',DamageEnum());
			WriteData(fid,'data',self.mesh_x,'format','DoubleMat','mattype',1,'enum',MeshXEnum());
			WriteData(fid,'data',self.mesh_y,'format','DoubleMat','mattype',1,'enum',MeshYEnum());
		end % }}}
	end
end
