def writejsfile(filename,model,keyname)
#WRITEJSFILE - write model file to javascript database
#
#   Usage:
#      writejsfile(filename,model,keyname)
#

	nods=len(model.x)
	nel=len(model.index[1])
	nx=len(model.contourx1)
	
	fid=open(filename,'w')

	fid.write('model = {};\n')
	fid.write('model["title"]="{0}";\n'.format(model.title)
	fid.write('model["initialZoomFactor"]={0};\n'.format(model.initialZoomFactor)
	
	#write index:
	fid.write('<!-- model["index"]{{{-->\n')
	fid.write('model["index"]=[')
	for i in xrange(1,nel-1):
		fid.write('[{0}, {1}, {2}],'.model.index[i][1],model.index[i][2],model.index[i][3])
	fid.write('[{0}, {1}, {2}]];\n'.format(model.index[-1][1],model.index[-1][2],model.index[-1][3])
	fid.write('<!--}}}-->\n')
	
	writejsfield(fid,'model["x"]',model.x,nods)
	writejsfield(fid,'model["y"]',model.y,nods)
	writejsfield(fid,'model["z"]',model.z,nods)
	writejsfield(fid,'model["surface"]',model.surface,nods)
	writejsfield(fid,'model["contourx1"]',model.contourx1,nx)
	writejsfield(fid,'model["contoury1"]',model.contoury1,nx)
	writejsfield(fid,'model["contourz1"]',model.contourz1,nx)
	writejsfield(fid,'model["contourx2"]',model.contourx2,nx)
	writejsfield(fid,'model["contoury2"]',model.contoury2,nx)
	writejsfield(fid,'model["contourz2"]',model.contourz2,nx)


	results=model.results
	fid.write('results={};\n')

	for i in xrange(1,len(results)):
		fid.write('result={};\n')
		writejsfield(fid,'result["data"]',results[i].data,nods)
		fid.write('<!--{{{-->\n')
		fid.write('result["caxis"]=[{0},{1}];\n'.format(results[i].caxis[1],results[i].caxis[2])
		fid.write('result["label"]="{0}";\n'.format(results[i].label)
		fid.write('result["shortlabel"]="{0}";\n'.format(results[i].shortlabel)
		fid.write('result["unit"]="{0}";\n'.format(results[i].unit)
		if len(results[i].data[2])>1:
			fid.write('result["time_range"]=[{0},{1}];\n'.format(results[i].time_range[1],results[i].time_range[2])
		fid.write('results["{0}"]=result;\n'.format[i]
		fid.write('<!--}}}-->\n')
	fid.write('model.results=results;\n')
	fid.write('models["{0}"]=model;\n'.format(keyname)

	fid.close()
