%MASSCON class definition
%
%   Usage:
%      masscon=masscon();
%      masscon=masscon('name','MassCon58',... %name of a North-East Greenland JPL MassCon
%                    'levelset',level);
% 
%   where level is a levelset vectorial field.
%
%   See also: MISFIT

classdef masscon
	properties (SetAccess=public)
		%masscon
		name              = '';
		definitionenum   = NaN; %enum that identifies this output definition uniquely, from Outputdefinition[1-10]Enum
		levelset          = NaN; %levelset vectorial field which identifies the boundaries of the masscon
	end
	
	methods
		function obj = masscon(varargin) % {{{
			if nargin==0,
				obj=setdefaultparameters(obj);
			else
				%use provided options to change fields
				options=pairoptions(varargin{:});

				%get name
				obj.name=getfieldvalue(options,'name','');
				obj.levelset=getfieldvalue(options,'levelset');
				obj.definitionenum=getfieldvalue(options,'definitionenum');

			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ~ischar(obj.name),
				error('masscon error message: ''name'' field should be a string!');
			end
			
			md = checkfield(md,'fieldname','obj.definitionenum','field',obj.definitionenum,'values',[Outputdefinition1Enum,Outputdefinition2Enum,Outputdefinition3Enum,Outputdefinition4Enum,Outputdefinition5Enum,Outputdefinition6Enum,Outputdefinition7Enum,Outputdefinition8Enum,Outputdefinition9Enum,Outputdefinition10Enum]);

			md = checkfield(md,'fieldname','obj.levelset','field',obj.levelset,'timeseries',1,'NaN',1);

		end % }}}
		function md = disp(obj) % {{{
		
			disp(sprintf('   Misfit:\n'));

			fielddisplay(obj,'name','identifier for this masscon response');
			fielddisplay(obj,'definitionenum','enum that identifies this output definition uniquely, from Outputdefinition[1-10]Enum');
			fielddisplay(obj,'levelset','levelset vectorial field which identifies the boundaries of the masscon');

		end % }}}
		function md = marshall(obj,md,fid) % {{{

		WriteData(fid,'object',obj,'fieldname','name','format','String');
		WriteData(fid,'object',obj,'fieldname','definitionenum','format','Integer');
		WriteData(fid,'object',obj,'fieldname','levelset','format','DoubleMat','mattype',1);

		end % }}}
	end
end
