%SMBmeltcomponents Class definition
%
%   Usage:
%      SMBmeltcomponents=SMBmeltcomponents();

classdef SMBmeltcomponents
	properties (SetAccess=public) 
		accumulation = NaN;
		evaporation = NaN;
		melt = NaN;
		refreeze = NaN;
	end
	methods
		function obj = SMBmeltcomponents(varargin) % {{{
			switch nargin
				case 0
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{

			self.accumulation=project3d(md,'vector',self.accumulation,'type','node');
			self.evaporation=project3d(md,'vector',self.evaporation,'type','node');
			self.melt=project3d(md,'vector',self.melt,'type','node');
			self.refreeze=project3d(md,'vector',self.refreeze,'type','node');

		end % }}}
		function self = initialize(self,md) % {{{

			if isnan(self.accumulation)
				self.accumulation=zeros(md.mesh.numberofvertices,1);
				disp('      no surfaceforcings.accumulation specified: values set as zero');
			end
			if isnan(self.evaporation)
				self.evaporation=zeros(md.mesh.numberofvertices,1);
				disp('      no surfaceforcings.evaporation specified: values set as zero');
			end
			if isnan(self.refreeze)
				self.refreeze=zeros(md.mesh.numberofvertices,1);
				disp('      no surfaceforcings.refreeze specified: values set as zero');
			end
			if isnan(self.melt)
				self.melt=zeros(md.mesh.numberofvertices,1);
				disp('      no surfaceforcings.melt specified: values set as zero');
			end

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.accumulation','timeseries',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.accumulation','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.evaporation','timeseries',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.evaporation','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.refreeze','timeseries',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.refreeze','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.melt','timeseries',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.melt','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   surface forcings parameters with melt (SMB=accumulation-evaporation-melt+refreeze) :'));
			fielddisplay(obj,'accumulation','accumulated snow [m/yr ice eq]');
			fielddisplay(obj,'evaporation','amount of ice lost to evaporative processes [m/yr ice eq]');
			fielddisplay(obj,'melt','amount of ice melt in ice column [m/yr ice eq]');
			fielddisplay(obj,'refreeze','amount of ice melt refrozen in ice column [m/yr ice eq]');
		end % }}}
		function marshall(obj,md,fid) % {{{

			yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBmeltcomponentsEnum(),'format','Integer');
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','accumulation','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','evaporation','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','melt','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','refreeze','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1);
		end % }}}
	end
end
