%SMB Class definition
%
%   Usage:
%      SMB=SMB();

classdef SMB
	properties (SetAccess=public) 
		mass_balance = NaN;
	end
	methods
        function createxml(obj,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- surfaceforcings(SMB) -->');
			 fprintf(fid,'%s%s%s%s%s\n%s\n%s\n','<parameter key ="mass_balance" type="',class(obj.mass_balance),'" default="',obj.mass_balance,'">','     <section name="surfaceforcings(SMB)" />','     <help> surface mass balance [m/yr ice eq] </help>','</parameter>');
           
        end % }}}
		function obj = SMB(varargin) % {{{
			switch nargin
				case 0
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{

			self.mass_balance=project3d(md,'vector',self.mass_balance,'type','node');

		end % }}}
		function self = initialize(self,md) % {{{

			if isnan(self.mass_balance)
				self.mass_balance=zeros(md.mesh.numberofvertices,1);
				disp('      no surfaceforcings.mass_balance specified: values set as zero');
			end

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.mass_balance','timeseries',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.mass_balance','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   surface forcings parameters:'));
			fielddisplay(obj,'mass_balance','surface mass balance [m/yr ice eq]');
		end % }}}
		function marshall(obj,md,fid) % {{{

			yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBEnum(),'format','Integer');
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','mass_balance','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1);
		end % }}}
	end
end
